"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddedConsoleResizeButton = void 0;
exports.getCurrentConsoleMaxSize = getCurrentConsoleMaxSize;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CONSOLE_MIN_HEIGHT = 200;
const getMouseOrTouchY = e => {
  // Some Typescript fooling is needed here
  const y = e.targetTouches ? e.targetTouches[0].pageY : e.pageY;
  return y;
};
function getCurrentConsoleMaxSize(euiTheme) {
  var _bodyStyle$getPropert;
  const euiBaseSize = parseInt(euiTheme.size.base, 10);
  const winHeight = window.innerHeight;
  const bodyStyle = getComputedStyle(document.body);
  const headerOffset = parseInt((_bodyStyle$getPropert = bodyStyle.getPropertyValue('--euiFixedHeadersOffset')) !== null && _bodyStyle$getPropert !== void 0 ? _bodyStyle$getPropert : '0px', 10);

  // We leave a buffer of baseSize to allow room for the user to hover on the top border for resizing
  return Math.max(winHeight - headerOffset - euiBaseSize, CONSOLE_MIN_HEIGHT);
}
const EmbeddedConsoleResizeButton = ({
  consoleHeight,
  setConsoleHeight
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [maxConsoleHeight, setMaxConsoleHeight] = (0, _react.useState)(800);
  const initialConsoleHeight = (0, _react.useRef)(consoleHeight);
  const initialMouseY = (0, _react.useRef)(0);
  (0, _react.useEffect)(() => {
    function handleResize() {
      const newMaxConsoleHeight = getCurrentConsoleMaxSize(euiTheme);
      // Calculate and save the console max height. This is the window height minus the header
      // offset minuse the base size to allow a small buffer for grabbing the resize button.
      if (maxConsoleHeight !== newMaxConsoleHeight) {
        setMaxConsoleHeight(newMaxConsoleHeight);
      }
      if (consoleHeight > newMaxConsoleHeight && newMaxConsoleHeight > CONSOLE_MIN_HEIGHT) {
        // When the current console height is greater than the new max height,
        // we resize the console to the max height. This will ensure there is not weird
        // behavior with the drag resize.
        setConsoleHeight(newMaxConsoleHeight);
      }
    }
    handleResize();
    window.addEventListener('resize', handleResize);
    return () => window.removeEventListener('resize', handleResize);
  }, [maxConsoleHeight, euiTheme, consoleHeight, setConsoleHeight]);
  const onResizeMouseMove = (0, _react.useCallback)(e => {
    const currentMouseY = getMouseOrTouchY(e);
    const mouseOffset = (currentMouseY - initialMouseY.current) * -1;
    const changedConsoleHeight = initialConsoleHeight.current + mouseOffset;
    const newConsoleHeight = Math.min(Math.max(changedConsoleHeight, CONSOLE_MIN_HEIGHT), maxConsoleHeight);
    setConsoleHeight(newConsoleHeight);
  }, [maxConsoleHeight, setConsoleHeight]);
  const onResizeMouseUp = (0, _react.useCallback)(e => {
    initialMouseY.current = 0;
    window.removeEventListener('mousemove', onResizeMouseMove);
    window.removeEventListener('mouseup', onResizeMouseUp);
    window.removeEventListener('touchmove', onResizeMouseMove);
    window.removeEventListener('touchend', onResizeMouseUp);
  }, [onResizeMouseMove]);
  const onResizeMouseDown = (0, _react.useCallback)(e => {
    initialMouseY.current = getMouseOrTouchY(e);
    initialConsoleHeight.current = consoleHeight;

    // Window event listeners instead of React events are used
    // in case the user's mouse leaves the component
    window.addEventListener('mousemove', onResizeMouseMove);
    window.addEventListener('mouseup', onResizeMouseUp);
    window.addEventListener('touchmove', onResizeMouseMove);
    window.addEventListener('touchend', onResizeMouseUp);
  }, [consoleHeight, onResizeMouseUp, onResizeMouseMove]);
  const onResizeKeyDown = (0, _react.useCallback)(e => {
    const KEYBOARD_OFFSET = 10;
    switch (e.key) {
      case _eui.keys.ARROW_UP:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setConsoleHeight(height => Math.min(height + KEYBOARD_OFFSET, maxConsoleHeight));
        break;
      case _eui.keys.ARROW_DOWN:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setConsoleHeight(height => Math.max(height - KEYBOARD_OFFSET, CONSOLE_MIN_HEIGHT));
    }
  }, [maxConsoleHeight, setConsoleHeight]);
  const onResizeDoubleClick = (0, _react.useCallback)(() => {
    if (consoleHeight < maxConsoleHeight) {
      setConsoleHeight(maxConsoleHeight);
    } else {
      setConsoleHeight(maxConsoleHeight / 2);
    }
  }, [consoleHeight, maxConsoleHeight, setConsoleHeight]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizableButton, {
    indicator: "border",
    isHorizontal: false,
    onMouseDown: onResizeMouseDown,
    onTouchStart: onResizeMouseDown,
    onKeyDown: onResizeKeyDown,
    onDoubleClick: onResizeDoubleClick
  });
};
exports.EmbeddedConsoleResizeButton = EmbeddedConsoleResizeButton;