"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.variablesExample = exports.multipleRequestsExample = exports.kibanaApiExample = exports.commentsExample = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const kibanaApiExample = exports.kibanaApiExample = `
# retrieve sets of saved objects 
POST kbn:api/saved_objects/_export
`;
const multipleRequestsExample = exports.multipleRequestsExample = `
# POST test_index/_doc/test_doc 200 OK
{
 "_index": "test_index",
 "_id": "test_doc",
 "_version": 3,
 "result": "updated",
 "_shards": {
   "total": 2,
   "successful": 1,
   "failed": 0
 },
 "_seq_no": 2,
 "_primary_term": 1
}
# POST notAnEndpoint 405 Method Not Allowed
{
 "error": "Incorrect HTTP method for uri [/notAnEndpoint?pretty=true] and method [POST], allowed: [HEAD, GET, PUT, DELETE]",
 "status": 405
}
`;
const commentsExample = exports.commentsExample = `
# This request searches all of your indices.
GET _search
{
 // The query parameter indicates query context.
 "query": {
   // Matches all documents.
   /*"match_all": {
     "boost": 1.2
   }*/
   "match_none": {} // Matches no document.
 }
}
`;
const variablesExample = exports.variablesExample = `
GET $\{pathVariable}
{
 "query": {
   "match": {
     "$\{bodyNameVariable}": "$\{bodyValueVariable}"
   }
 }
}
`;