"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationType = void 0;
var _typeDetect = _interopRequireDefault(require("type-detect"));
var _duration = require("../duration");
var _errors = require("../errors");
var _internals = require("../internals");
var _type = require("./type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DurationType extends _type.Type {
  constructor(options = {}) {
    let defaultValue;
    if (typeof options.defaultValue === 'function') {
      const originalDefaultValue = options.defaultValue;
      defaultValue = () => (0, _duration.ensureDuration)(originalDefaultValue());
    } else if (typeof options.defaultValue === 'string' || typeof options.defaultValue === 'number') {
      defaultValue = (0, _duration.ensureDuration)(options.defaultValue);
    } else {
      defaultValue = options.defaultValue;
    }
    let schema = _internals.internals.duration();
    if (options.min) {
      schema = schema.min(options.min);
    }
    if (options.max) {
      schema = schema.max(options.max);
    }
    super(schema, {
      validate: options.validate,
      defaultValue
    });
  }
  handleError(type, {
    message,
    value,
    limit
  }, path) {
    switch (type) {
      case 'any.required':
      case 'duration.base':
        return `expected value of type [moment.Duration] but got [${(0, _typeDetect.default)(value)}]`;
      case 'duration.parse':
        return new _errors.SchemaTypeError(message, path);
      case 'duration.min':
        return `Value must be equal to or greater than [${limit.toString()}]`;
      case 'duration.max':
        return `Value must be equal to or less than [${limit.toString()}]`;
    }
  }
}
exports.DurationType = DurationType;