"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vulnerabilityDashboardTableContent = exports.DASHBOARD_TABLE_TYPES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let DASHBOARD_TABLE_TYPES = exports.DASHBOARD_TABLE_TYPES = /*#__PURE__*/function (DASHBOARD_TABLE_TYPES) {
  DASHBOARD_TABLE_TYPES["TOP_VULNERABLE_RESOURCES"] = "topVulnerableResources";
  DASHBOARD_TABLE_TYPES["TOP_PATCH_VULNERABILITIES"] = "topPatchVulnerabilities";
  DASHBOARD_TABLE_TYPES["TOP_VULNERABILITIES"] = "topVulnerabilities";
  return DASHBOARD_TABLE_TYPES;
}({});
const vulnerabilityDashboardTableContent = exports.vulnerabilityDashboardTableContent = {
  [DASHBOARD_TABLE_TYPES.TOP_VULNERABLE_RESOURCES]: {
    title: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.panel.topVulnerableResources.title', {
      defaultMessage: 'Top 10 vulnerable resources'
    })
  },
  [DASHBOARD_TABLE_TYPES.TOP_PATCH_VULNERABILITIES]: {
    title: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.panel.topPatchVulnerabilities.title', {
      defaultMessage: 'Top 10 patchable vulnerabilities'
    })
  },
  [DASHBOARD_TABLE_TYPES.TOP_VULNERABILITIES]: {
    title: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.panel.topVulnerabilities.title', {
      defaultMessage: 'Top 10 vulnerabilities'
    })
  }
};