"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.severitySortScript = exports.severitySchemaConfig = exports.getCaseInsensitiveSortScript = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const severitySchemaConfig = exports.severitySchemaConfig = {
  type: 'severitySchema',
  detector() {
    return 0; // this schema is always explicitly defined
  },
  sortTextAsc: _i18n.i18n.translate('xpack.csp.vulnerabilityTable.column.sortAscending', {
    defaultMessage: 'Low -> Critical'
  }),
  sortTextDesc: _i18n.i18n.translate('xpack.csp.vulnerabilityTable.column.sortDescending', {
    defaultMessage: 'Critical -> Low'
  }),
  icon: 'dot',
  color: ''
};
const severitySortScript = direction => ({
  _script: {
    type: 'number',
    script: {
      lang: 'painless',
      inline: "if(doc.containsKey('vulnerability.severity') && !doc['vulnerability.severity'].empty && doc['vulnerability.severity'].size()!=0 && doc['vulnerability.severity'].value!=null && params.scores.containsKey(doc['vulnerability.severity'].value)) { return params.scores[doc['vulnerability.severity'].value];} return 0;",
      params: {
        scores: {
          LOW: 1,
          MEDIUM: 2,
          HIGH: 3,
          CRITICAL: 4
        }
      }
    },
    order: direction
  }
});

/**
 * Generates Painless sorting in case-insensitive manner
 */
exports.severitySortScript = severitySortScript;
const getCaseInsensitiveSortScript = (field, direction) => {
  return {
    _script: {
      type: 'string',
      order: direction,
      script: {
        source: `doc["${field}"].value.toLowerCase()`,
        lang: 'painless'
      }
    }
  };
};
exports.getCaseInsensitiveSortScript = getCaseInsensitiveSortScript;