"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultQuery = exports.defaultGroupingOptions = exports.defaultColumns = exports.VULNERABILITY_FIELDS = exports.GROUPING_OPTIONS = void 0;
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VULNERABILITY_FIELDS = exports.VULNERABILITY_FIELDS = {
  VULNERABILITY_ID: 'vulnerability.id',
  SCORE_BASE: 'vulnerability.score.base',
  RESOURCE_NAME: 'resource.name',
  RESOURCE_ID: 'resource.id',
  SEVERITY: 'vulnerability.severity',
  PACKAGE_NAME: 'package.name',
  PACKAGE_VERSION: 'package.version',
  PACKAGE_FIXED_VERSION: 'package.fixed_version',
  CLOUD_ACCOUNT_NAME: 'cloud.account.name',
  CLOUD_PROVIDER: 'cloud.provider',
  DESCRIPTION: 'vulnerability.description'
};
const GROUPING_OPTIONS = exports.GROUPING_OPTIONS = {
  RESOURCE_NAME: VULNERABILITY_FIELDS.RESOURCE_NAME,
  CLOUD_ACCOUNT_NAME: VULNERABILITY_FIELDS.CLOUD_ACCOUNT_NAME,
  CVE: VULNERABILITY_FIELDS.VULNERABILITY_ID
};
const defaultGroupingOptions = exports.defaultGroupingOptions = [{
  label: _translations.GROUPING_LABELS.RESOURCE_NAME,
  key: GROUPING_OPTIONS.RESOURCE_NAME
}, {
  label: _translations.GROUPING_LABELS.CLOUD_ACCOUNT_NAME,
  key: GROUPING_OPTIONS.CLOUD_ACCOUNT_NAME
}, {
  label: 'CVE',
  key: GROUPING_OPTIONS.CVE
}];
const getDefaultQuery = ({
  query,
  filters
}) => ({
  query,
  filters,
  sort: [[VULNERABILITY_FIELDS.SEVERITY, 'asc'], [VULNERABILITY_FIELDS.SCORE_BASE, 'desc']]
});
exports.getDefaultQuery = getDefaultQuery;
const defaultColumns = exports.defaultColumns = [{
  id: VULNERABILITY_FIELDS.VULNERABILITY_ID,
  width: 130
}, {
  id: VULNERABILITY_FIELDS.SCORE_BASE,
  width: 80
}, {
  id: VULNERABILITY_FIELDS.RESOURCE_NAME
}, {
  id: VULNERABILITY_FIELDS.RESOURCE_ID
}, {
  id: VULNERABILITY_FIELDS.SEVERITY,
  width: 100
}, {
  id: VULNERABILITY_FIELDS.PACKAGE_NAME
}, {
  id: VULNERABILITY_FIELDS.PACKAGE_VERSION
}, {
  id: VULNERABILITY_FIELDS.PACKAGE_FIXED_VERSION
}];