"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChangeCspRuleState = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _use_get_benchmark_rules_state_api = require("../configurations/latest_findings/use_get_benchmark_rules_state_api");
var _api = require("../../common/api");
var _use_csp_benchmark_integrations = require("../benchmarks/use_csp_benchmark_integrations");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useChangeCspRuleState = () => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  return async (actionOnRule, ruleIds) => {
    const query = {
      action: actionOnRule,
      rules: ruleIds
    };
    const cspRuleBulkActionResponse = await (http === null || http === void 0 ? void 0 : http.post(_constants.CSP_BENCHMARK_RULES_BULK_ACTION_ROUTE_PATH, {
      version: '1',
      body: JSON.stringify(query)
    }));
    await queryClient.invalidateQueries(_use_csp_benchmark_integrations.BENCHMARK_INTEGRATION_QUERY_KEY_V2); // causing rules counters refetch
    await queryClient.invalidateQueries(_api.getCspmStatsKey); // causing cloud dashboard refetch
    await queryClient.invalidateQueries(_api.getKspmStatsKey); // causing kubernetes dashboard refetch
    await queryClient.invalidateQueries(_use_get_benchmark_rules_state_api.getRuleStatesKey); // the rule states are part of the findings query key, invalidating them will cause the latest findings to refetch only after the rules states were changed

    return cspRuleBulkActionResponse;
  };
};
exports.useChangeCspRuleState = useChangeCspRuleState;