"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Findings = void 0;
var _react = _interopRequireDefault(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _configurations = require("../configurations");
var _constants = require("../../common/navigation/constants");
var _constants2 = require("../../common/constants");
var _constants3 = require("../../../common/constants");
var _use_setup_status_api = require("../../common/api/use_setup_status_api");
var _helpers = require("../../../common/utils/helpers");
var _vulnerabilities = require("../vulnerabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FindingsTabRedirecter = ({
  lastTabSelected
}) => {
  const location = (0, _reactRouterDom.useLocation)();
  const getSetupStatus = (0, _use_setup_status_api.useCspSetupStatusApi)();
  if (!getSetupStatus.data) {
    return null;
  }
  const vulnStatus = (0, _helpers.getStatusForIndexName)(_constants3.VULNERABILITIES_INDEX_NAME, getSetupStatus.data);
  const findingsStatus = (0, _helpers.getStatusForIndexName)(_constants3.FINDINGS_INDEX_NAME, getSetupStatus.data);
  const hasVulnerabilities = vulnStatus === 'not-empty';
  const hasFindings = findingsStatus === 'not-empty';

  // if the user has not yet made a tab selection
  // switch to misconfigurations page if there are misconfigurations, and no vulnerabilities
  const redirectToMisconfigurationsTab = lastTabSelected === 'configurations' || !lastTabSelected && !hasVulnerabilities && hasFindings;
  if (redirectToMisconfigurationsTab) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        search: location.search,
        pathname: _constants.findingsNavigation.findings_default.path
      }
    });
  }

  // otherwise stay on the misconfigurations tab, since it's the first one.
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      search: location.search,
      pathname: _constants.findingsNavigation.findings_default.path
    }
  });
};
const Findings = () => {
  var _matchPath, _matchPath2;
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();

  // restore the users most recent tab selection
  const [lastTabSelected, setLastTabSelected] = (0, _useLocalStorage.default)(_constants2.LOCAL_STORAGE_FINDINGS_LAST_SELECTED_TAB_KEY);
  const navigateToVulnerabilitiesTab = () => {
    setLastTabSelected('vuln_mgmt');
    history.push({
      pathname: _constants.findingsNavigation.vulnerabilities.path
    });
  };
  const navigateToConfigurationsTab = () => {
    setLastTabSelected('configurations');
    history.push({
      pathname: _constants.findingsNavigation.findings_default.path
    });
  };
  const isResourcesVulnerabilitiesPage = (_matchPath = (0, _reactRouterDom.matchPath)(location.pathname, {
    path: _constants.findingsNavigation.resource_vulnerabilities.path
  })) === null || _matchPath === void 0 ? void 0 : _matchPath.isExact;
  const isResourcesFindingsPage = (_matchPath2 = (0, _reactRouterDom.matchPath)(location.pathname, {
    path: _constants.findingsNavigation.resource_findings.path
  })) === null || _matchPath2 === void 0 ? void 0 : _matchPath2.isExact;
  const showHeader = !isResourcesVulnerabilitiesPage && !isResourcesFindingsPage;
  const isVulnerabilitiesTabSelected = pathname => {
    return pathname === _constants.findingsNavigation.vulnerabilities.path || pathname === _constants.findingsNavigation.vulnerabilities_by_resource.path;
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showHeader && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.title",
    defaultMessage: "Findings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: "configurations",
    onClick: navigateToConfigurationsTab,
    isSelected: !isVulnerabilitiesTabSelected(location.pathname)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.tabs.misconfigurations",
    defaultMessage: "Misconfigurations"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: "vuln_mgmt",
    onClick: navigateToVulnerabilitiesTab,
    isSelected: isVulnerabilitiesTabSelected(location.pathname)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.tabs.vulnerabilities",
    defaultMessage: "Vulnerabilities"
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.cloudPosturePages.findings.path,
    render: () => /*#__PURE__*/_react.default.createElement(FindingsTabRedirecter, {
      lastTabSelected: lastTabSelected
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.findingsNavigation.findings_default.path,
    component: _configurations.Configurations
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.findingsNavigation.findings_by_resource.path,
    component: _configurations.Configurations
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.findingsNavigation.vulnerabilities.path,
    component: _vulnerabilities.Vulnerabilities
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.findingsNavigation.vulnerabilities_by_resource.path,
    component: _vulnerabilities.Vulnerabilities
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "*",
    render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.findingsNavigation.findings_default.path
    })
  })));
};
exports.Findings = Findings;