"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestFindingsTable = void 0;
var _react = require("react");
var _data_view_context = require("../../../common/contexts/data_view_context");
var _constants = require("../../../common/constants");
var _use_cloud_posture_data_table = require("../../../common/hooks/use_cloud_posture_data_table");
var _get_filters = require("../utils/get_filters");
var _use_latest_findings = require("./use_latest_findings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columnsLocalStorageKey = 'cloudPosture:latestFindings:columns';
const useLatestFindingsTable = ({
  getDefaultQuery,
  nonPersistedFilters,
  showDistributionBar
}) => {
  const {
    dataView
  } = (0, _data_view_context.useDataViewContext)();
  const cloudPostureDataTable = (0, _use_cloud_posture_data_table.useCloudPostureDataTable)({
    paginationLocalStorageKey: _constants.LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY,
    columnsLocalStorageKey,
    defaultQuery: getDefaultQuery,
    nonPersistedFilters
  });
  const {
    query,
    sort,
    queryError,
    setUrlQuery,
    filters,
    getRowsFromPages,
    pageSize
  } = cloudPostureDataTable;
  const {
    data,
    error: fetchError,
    isFetching,
    fetchNextPage
  } = (0, _use_latest_findings.useLatestFindings)({
    query,
    sort,
    enabled: !queryError,
    pageSize
  });
  const rows = (0, _react.useMemo)(() => getRowsFromPages(data === null || data === void 0 ? void 0 : data.pages), [data === null || data === void 0 ? void 0 : data.pages, getRowsFromPages]);
  const error = fetchError || queryError;
  const passed = (data === null || data === void 0 ? void 0 : data.pages[0].count.passed) || 0;
  const failed = (data === null || data === void 0 ? void 0 : data.pages[0].count.failed) || 0;
  const total = (data === null || data === void 0 ? void 0 : data.pages[0].total) || 0;
  const onDistributionBarClick = evaluation => {
    setUrlQuery({
      filters: (0, _get_filters.getFilters)({
        filters,
        dataView,
        field: 'result.evaluation',
        value: evaluation,
        negate: false
      })
    });
  };
  const canShowDistributionBar = showDistributionBar && total > 0;
  return {
    cloudPostureDataTable,
    rows,
    error,
    isFetching,
    fetchNextPage,
    passed,
    failed,
    total,
    canShowDistributionBar,
    onDistributionBarClick
  };
};
exports.useLatestFindingsTable = useLatestFindingsTable;