"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleList = exports.RuleTab = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _rules_detection_rule_counter = require("../../rules/rules_detection_rule_counter");
var _findings_flyout = require("./findings_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleList = (rule, ruleState = 'unmuted', ruleFlyoutLink) => [{
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.nameTitle', {
    defaultMessage: 'Name'
  }),
  description: ruleFlyoutLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.nameTooltip', {
      defaultMessage: 'Manage Rule'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: ruleFlyoutLink
  }, rule.name)) : rule.name
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.descriptionTitle', {
    defaultMessage: 'Description'
  }),
  description: /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.description)
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.AlertsTitle', {
    defaultMessage: 'Alerts'
  }),
  description: ruleState === 'unmuted' ? /*#__PURE__*/_react.default.createElement(_rules_detection_rule_counter.RulesDetectionRuleCounter, {
    benchmarkRule: rule
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.findingsFlyout.ruleTab.disabledRuleText",
    defaultMessage: "Disabled"
  })
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.tagsTitle', {
    defaultMessage: 'Tags'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rule.tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag
  }, tag)))
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.frameworkSourcesTitle', {
    defaultMessage: 'Framework Sources'
  }),
  description: /*#__PURE__*/_react.default.createElement(_findings_flyout.CisKubernetesIcons, {
    benchmarkId: rule.benchmark.id,
    benchmarkName: rule.benchmark.name
  })
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.cisSectionTitle', {
    defaultMessage: 'CIS Section'
  }),
  description: rule.section
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.profileApplicabilityTitle', {
    defaultMessage: 'Profile Applicability'
  }),
  description: /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.profile_applicability)
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.benchmarkTitle', {
    defaultMessage: 'Benchmark'
  }),
  description: rule.benchmark.name
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.auditTitle', {
    defaultMessage: 'Audit'
  }),
  description: /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.audit)
}, ...(rule.references ? [{
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.referencesTitle', {
    defaultMessage: 'References'
  }),
  description: /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.references)
}] : [])];
exports.getRuleList = getRuleList;
const RuleTab = ({
  data,
  ruleFlyoutLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: getRuleList(data.rule, ruleFlyoutLink)
  });
};
exports.RuleTab = RuleTab;