"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _codeEditor = require("@kbn/code-editor");
var _monaco = require("@kbn/monaco");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const offsetTopHeight = 120;
const offsetBottomHeight = 72;
const JsonTab = ({
  data
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    position: 'absolute',
    inset: 0,
    top: offsetTopHeight,
    bottom: offsetBottomHeight
  }
}, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
  isCopyable: true,
  allowFullScreen: true,
  languageId: _monaco.XJsonLang.ID,
  value: JSON.stringify(data, null, 2),
  options: {
    readOnly: true,
    lineNumbers: 'on',
    folding: true
  }
}));
exports.JsonTab = JsonTab;