"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GcpCredentialsFormAgentless = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _gcp_credential_form = require("./gcp_credential_form");
var _utils = require("../utils");
var _aws_credentials_form = require("../aws_credentials_form/aws_credentials_form");
var _constants = require("../../../common/navigation/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GcpCredentialsFormAgentless = ({
  input,
  newPolicy,
  updatePolicy,
  disabled
}) => {
  var _input$streams, _input$streams$, _input$streams$$vars, _input$streams$$vars$;
  const accountType = (_input$streams = input.streams) === null || _input$streams === void 0 ? void 0 : (_input$streams$ = _input$streams[0]) === null || _input$streams$ === void 0 ? void 0 : (_input$streams$$vars = _input$streams$.vars) === null || _input$streams$$vars === void 0 ? void 0 : (_input$streams$$vars$ = _input$streams$$vars['gcp.account_type']) === null || _input$streams$$vars$ === void 0 ? void 0 : _input$streams$$vars$.value;
  const isOrganization = accountType === 'organization-account';
  const organizationFields = ['gcp.organization_id', 'gcp.credentials.json'];
  const singleAccountFields = ['gcp.project_id', 'gcp.credentials.json'];

  /*
    For Agentless only JSON credentials type is supported.
    Also in case of organisation setup, project_id is not required in contrast to Agent-based.
   */
  const fields = (0, _gcp_credential_form.getInputVarsFields)(input, _gcp_credential_form.gcpField.fields).filter(field => {
    if (isOrganization) {
      return organizationFields.includes(field.id);
    } else {
      return singleAccountFields.includes(field.id);
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_gcp_credential_form.GCPSetupInfoContent, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_gcp_credential_form.GcpInputVarFields, {
    disabled: disabled,
    fields: fields,
    onChange: (key, value) => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      [key]: {
        value
      }
    })),
    isOrganization: isOrganization
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.ReadDocumentation, {
    url: _constants.cspIntegrationDocsNavigation.cspm.getStartedPath
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.GcpCredentialsFormAgentless = GcpCredentialsFormAgentless;