"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThemeDarkModeToggle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _userProfileComponents = require("@kbn/user-profile-components");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _theme_darkmode_hook = require("./theme_darkmode_hook");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThemeDarkModeToggle = ({
  security,
  core
}) => {
  return /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesKibanaProvider, {
    core: core,
    security: security,
    toMountPoint: _reactKibanaMount.toMountPoint
  }, /*#__PURE__*/_react.default.createElement(ThemeDarkModeToggleUi, {
    uiSettingsClient: core.uiSettings
  }));
};
exports.ThemeDarkModeToggle = ThemeDarkModeToggle;
function ThemeDarkModeToggleUi({
  uiSettingsClient
}) {
  const toggleTextSwitchId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'toggleTextSwitch'
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isVisible,
    toggle,
    isDarkModeOn,
    colorScheme
  } = (0, _theme_darkmode_hook.useThemeDarkmodeToggle)({
    uiSettingsClient
  });
  if (!isVisible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: colorScheme === 'dark' ? 'moon' : 'sun',
    size: "s",
    onClick: () => {
      const on = colorScheme === 'light' ? true : false;
      toggle(on);
    },
    "data-test-subj": "darkModeToggle"
  }, _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.darkModeToggle', {
    defaultMessage: 'Dark mode'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      paddingRight: euiTheme.size.m
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: isDarkModeOn ? _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.darkModeOnLabel', {
      defaultMessage: 'on'
    }) : _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.darkModeOffLabel', {
      defaultMessage: 'off'
    }),
    showLabel: false,
    checked: isDarkModeOn,
    onChange: e => {
      toggle(e.target.checked);
    },
    "aria-describedby": toggleTextSwitchId,
    "data-test-subj": "darkModeToggleSwitch",
    compressed: true
  })));
}