"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createHelpMenuLinks = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _connection_details_modal = require("./connection_details_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createHelpMenuLinks = ({
  docLinks,
  helpSupportUrl,
  core,
  cloud,
  share
}) => {
  const {
    overlays
  } = core;
  const helpMenuLinks = [{
    title: _i18n.i18n.translate('xpack.cloudLinks.helpMenuLinks.documentation', {
      defaultMessage: 'Documentation'
    }),
    href: docLinks.links.elasticStackGetStarted
  }, {
    title: _i18n.i18n.translate('xpack.cloudLinks.helpMenuLinks.support', {
      defaultMessage: 'Support'
    }),
    href: helpSupportUrl
  }, {
    title: _i18n.i18n.translate('xpack.cloudLinks.helpMenuLinks.giveFeedback', {
      defaultMessage: 'Give feedback'
    }),
    href: docLinks.links.kibana.feedback
  }, {
    title: _i18n.i18n.translate('xpack.cloudLinks.helpMenuLinks.connectionDetails', {
      defaultMessage: 'Connection details'
    }),
    dataTestSubj: 'connectionDetailsHelpLink',
    onClick: () => {
      const modal = overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_connection_details_modal.ConnectionDetailsModal, {
        core: core,
        share: share,
        cloud: cloud,
        docLinks: docLinks,
        closeModal: () => modal.close()
      }), {
        theme: core.theme,
        i18n: core.i18n
      }));
    }
  }];
  return helpMenuLinks;
};
exports.createHelpMenuLinks = createHelpMenuLinks;