"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LaunchDarklyClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LaunchDarklyClient {
  constructor(ldConfig, kibanaVersion) {
    (0, _defineProperty2.default)(this, "launchDarklyClient", void 0);
    this.ldConfig = ldConfig;
    this.kibanaVersion = kibanaVersion;
  }
  async updateUserMetadata(userMetadata) {
    const {
      userId,
      ...userMetadataWithoutUserId
    } = userMetadata;
    const launchDarklyUser = {
      ...userMetadataWithoutUserId,
      kind: 'user',
      key: userId
    };
    if (this.launchDarklyClient) {
      await this.launchDarklyClient.identify(launchDarklyUser);
    } else {
      const {
        initialize,
        basicLogger
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('launchdarkly-js-client-sdk')));
      this.launchDarklyClient = initialize(this.ldConfig.client_id, launchDarklyUser, {
        application: {
          id: 'kibana-browser',
          version: this.kibanaVersion
        },
        logger: basicLogger({
          level: this.ldConfig.client_log_level
        })
      });
    }
  }
  async getVariation(configKey, defaultValue) {
    if (!this.launchDarklyClient) return defaultValue; // Skip any action if no LD User is defined
    await this.launchDarklyClient.waitForInitialization();
    return await this.launchDarklyClient.variation(configKey, defaultValue);
  }
  reportMetric(metricName, meta, value) {
    if (!this.launchDarklyClient) return; // Skip any action if no LD User is defined
    this.launchDarklyClient.track(metricName, meta, value);
  }
  stop() {
    var _this$launchDarklyCli;
    (_this$launchDarklyCli = this.launchDarklyClient) === null || _this$launchDarklyCli === void 0 ? void 0 : _this$launchDarklyCli.flush()
    // eslint-disable-next-line no-console
    .catch(err => console.warn(err));
  }
}
exports.LaunchDarklyClient = LaunchDarklyClient;