"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudDataMigrationApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app = require("../../app.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CloudDataMigrationApp = ({
  http,
  breadcrumbService
}) => {
  var _http$basePath$get;
  const basePath = (_http$basePath$get = http.basePath.get()) !== null && _http$basePath$get !== void 0 ? _http$basePath$get : '';
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const listItemProps = {
    iconType: 'checkInCircleFilled',
    iconProps: {
      color: 'success'
    },
    wrapText: true
  };
  const styles = (0, _app.getAppStyles)(euiTheme);
  (0, _react.useEffect)(() => {
    breadcrumbService.setBreadcrumbs('home');
  }, [breadcrumbService]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: styles.panelCss,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    gutterSize: "xl",
    justifyContent: "spaceBetween",
    css: styles.layoutCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: _i18n.i18n.translate('xpack.cloudDataMigration.illustration.alt.text', {
      defaultMessage: 'Illustration for cloud data migration'
    }),
    css: styles.illustrationCss,
    src: `${basePath}/plugins/kibanaReact/assets/` + 'illustration_cloud_migration.png'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudDataMigration.migrateToCloudTitle",
    defaultMessage: "Be faster and more efficient with Elastic Cloud"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    maxWidth: 700
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, (0, _extends2.default)({}, listItemProps, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: styles.listItemCss,
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudDataMigration.deployInSeconds.text",
      defaultMessage: "Deploy and scale a secure Elastic Stack in minutes"
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, (0, _extends2.default)({}, listItemProps, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: styles.listItemCss,
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudDataMigration.monitorDeployments.text",
      defaultMessage: "Monitor and manage multiple deployments from a single place"
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, (0, _extends2.default)({}, listItemProps, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: styles.listItemCss,
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudDataMigration.upgrade.text",
      defaultMessage: "Upgrade to newer versions much more easily"
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, (0, _extends2.default)({}, listItemProps, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: styles.listItemCss,
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudDataMigration.slaBackedSupport.text",
      defaultMessage: "Get all of your questions answered with SLA-backed support"
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    target: "_blank",
    href: "https://ela.st/cloud-migration"
    // data-test-subj used for Telemetry
    ,
    "data-test-subj": "migrate_data_to_cloud__stack_management_link"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudDataMigration.readInstructionsButtonLabel",
    defaultMessage: "Move to Elastic Cloud"
  }))))));
};
exports.CloudDataMigrationApp = CloudDataMigrationApp;