"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestCasesDates = exports.getCasesTelemetryData = void 0;
var _common = require("@kbn/files-plugin/common");
var _esQuery = require("@kbn/es-query");
var _constants = require("../../../common/constants");
var _utils = require("./utils");
var _case = require("../../common/types/case");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLatestCasesDates = async ({
  savedObjectsClient
}) => {
  var _savedObjects$0$saved, _savedObjects$, _savedObjects$$saved_, _savedObjects$$saved_2, _savedObjects$$saved_3, _savedObjects$1$saved, _savedObjects$2, _savedObjects$2$saved, _savedObjects$2$saved2, _savedObjects$2$saved3, _savedObjects$2$saved4, _savedObjects$3, _savedObjects$3$saved, _savedObjects$3$saved2, _savedObjects$3$saved3;
  const find = async sortField => savedObjectsClient.find({
    page: 1,
    perPage: 1,
    sortField,
    sortOrder: 'desc',
    type: _constants.CASE_SAVED_OBJECT
  });
  const savedObjects = await Promise.all([find('created_at'), find('updated_at'), find('closed_at')]);
  return {
    createdAt: (_savedObjects$0$saved = savedObjects === null || savedObjects === void 0 ? void 0 : (_savedObjects$ = savedObjects[0]) === null || _savedObjects$ === void 0 ? void 0 : (_savedObjects$$saved_ = _savedObjects$.saved_objects) === null || _savedObjects$$saved_ === void 0 ? void 0 : (_savedObjects$$saved_2 = _savedObjects$$saved_[0]) === null || _savedObjects$$saved_2 === void 0 ? void 0 : (_savedObjects$$saved_3 = _savedObjects$$saved_2.attributes) === null || _savedObjects$$saved_3 === void 0 ? void 0 : _savedObjects$$saved_3.created_at) !== null && _savedObjects$0$saved !== void 0 ? _savedObjects$0$saved : '',
    updatedAt: (_savedObjects$1$saved = savedObjects === null || savedObjects === void 0 ? void 0 : (_savedObjects$2 = savedObjects[1]) === null || _savedObjects$2 === void 0 ? void 0 : (_savedObjects$2$saved = _savedObjects$2.saved_objects) === null || _savedObjects$2$saved === void 0 ? void 0 : (_savedObjects$2$saved2 = _savedObjects$2$saved[0]) === null || _savedObjects$2$saved2 === void 0 ? void 0 : (_savedObjects$2$saved3 = _savedObjects$2$saved2.attributes) === null || _savedObjects$2$saved3 === void 0 ? void 0 : _savedObjects$2$saved3.updated_at) !== null && _savedObjects$1$saved !== void 0 ? _savedObjects$1$saved : '',
    closedAt: (_savedObjects$2$saved4 = savedObjects === null || savedObjects === void 0 ? void 0 : (_savedObjects$3 = savedObjects[2]) === null || _savedObjects$3 === void 0 ? void 0 : (_savedObjects$3$saved = _savedObjects$3.saved_objects) === null || _savedObjects$3$saved === void 0 ? void 0 : (_savedObjects$3$saved2 = _savedObjects$3$saved[0]) === null || _savedObjects$3$saved2 === void 0 ? void 0 : (_savedObjects$3$saved3 = _savedObjects$3$saved2.attributes) === null || _savedObjects$3$saved3 === void 0 ? void 0 : _savedObjects$3$saved3.closed_at) !== null && _savedObjects$2$saved4 !== void 0 ? _savedObjects$2$saved4 : ''
  };
};
exports.getLatestCasesDates = getLatestCasesDates;
const getCasesTelemetryData = async ({
  savedObjectsClient,
  logger
}) => {
  try {
    var _casesRes$aggregation, _casesRes$aggregation2, _casesRes$aggregation3, _commentsRes$aggregat, _commentsRes$aggregat2, _commentsRes$aggregat3, _casesRes$aggregation4, _casesRes$aggregation5, _casesRes$aggregation6, _totalAlertsRes$aggre, _totalAlertsRes$aggre2, _totalAlertsRes$aggre3, _totalAlertsRes$aggre4, _totalAlertsRes$aggre5, _totalConnectorsRes$a, _totalConnectorsRes$a2, _totalConnectorsRes$a3, _totalConnectorsRes$a4, _totalConnectorsRes$a5, _casesRes$aggregation7, _casesRes$aggregation8, _casesRes$aggregation9, _casesRes$aggregation10, _casesRes$aggregation11, _casesRes$aggregation12;
    const [casesRes, commentsRes, totalAlertsRes, totalConnectorsRes, latestDates, filesRes] = await Promise.all([getCasesSavedObjectTelemetry(savedObjectsClient), getCommentsSavedObjectTelemetry(savedObjectsClient), getAlertsTelemetry(savedObjectsClient), getConnectorsTelemetry(savedObjectsClient), getLatestCasesDates({
      savedObjectsClient,
      logger
    }), getFilesTelemetry(savedObjectsClient)]);
    const aggregationsBuckets = (0, _utils.getAggregationsBuckets)({
      aggs: casesRes.aggregations,
      keys: ['counts', 'syncAlerts', 'status', 'users', 'totalAssignees']
    });
    const allAttachmentFrameworkStats = (0, _utils.getAttachmentsFrameworkStats)({
      attachmentAggregations: commentsRes.aggregations,
      totalCasesForOwner: casesRes.total,
      filesAggregations: filesRes.aggregations
    });
    return {
      all: {
        total: casesRes.total,
        ...(0, _utils.getCountsFromBuckets)(aggregationsBuckets.counts),
        status: {
          open: (0, _utils.findValueInBuckets)(aggregationsBuckets.status, _case.CasePersistedStatus.OPEN),
          inProgress: (0, _utils.findValueInBuckets)(aggregationsBuckets.status, _case.CasePersistedStatus.IN_PROGRESS),
          closed: (0, _utils.findValueInBuckets)(aggregationsBuckets.status, _case.CasePersistedStatus.CLOSED)
        },
        syncAlertsOn: (0, _utils.findValueInBuckets)(aggregationsBuckets.syncAlerts, 1),
        syncAlertsOff: (0, _utils.findValueInBuckets)(aggregationsBuckets.syncAlerts, 0),
        totalUsers: (_casesRes$aggregation = (_casesRes$aggregation2 = casesRes.aggregations) === null || _casesRes$aggregation2 === void 0 ? void 0 : (_casesRes$aggregation3 = _casesRes$aggregation2.users) === null || _casesRes$aggregation3 === void 0 ? void 0 : _casesRes$aggregation3.value) !== null && _casesRes$aggregation !== void 0 ? _casesRes$aggregation : 0,
        totalParticipants: (_commentsRes$aggregat = (_commentsRes$aggregat2 = commentsRes.aggregations) === null || _commentsRes$aggregat2 === void 0 ? void 0 : (_commentsRes$aggregat3 = _commentsRes$aggregat2.participants) === null || _commentsRes$aggregat3 === void 0 ? void 0 : _commentsRes$aggregat3.value) !== null && _commentsRes$aggregat !== void 0 ? _commentsRes$aggregat : 0,
        totalTags: (_casesRes$aggregation4 = (_casesRes$aggregation5 = casesRes.aggregations) === null || _casesRes$aggregation5 === void 0 ? void 0 : (_casesRes$aggregation6 = _casesRes$aggregation5.tags) === null || _casesRes$aggregation6 === void 0 ? void 0 : _casesRes$aggregation6.value) !== null && _casesRes$aggregation4 !== void 0 ? _casesRes$aggregation4 : 0,
        totalWithAlerts: (_totalAlertsRes$aggre = (_totalAlertsRes$aggre2 = totalAlertsRes.aggregations) === null || _totalAlertsRes$aggre2 === void 0 ? void 0 : (_totalAlertsRes$aggre3 = _totalAlertsRes$aggre2.references) === null || _totalAlertsRes$aggre3 === void 0 ? void 0 : (_totalAlertsRes$aggre4 = _totalAlertsRes$aggre3.referenceType) === null || _totalAlertsRes$aggre4 === void 0 ? void 0 : (_totalAlertsRes$aggre5 = _totalAlertsRes$aggre4.referenceAgg) === null || _totalAlertsRes$aggre5 === void 0 ? void 0 : _totalAlertsRes$aggre5.value) !== null && _totalAlertsRes$aggre !== void 0 ? _totalAlertsRes$aggre : 0,
        totalWithConnectors: (_totalConnectorsRes$a = (_totalConnectorsRes$a2 = totalConnectorsRes.aggregations) === null || _totalConnectorsRes$a2 === void 0 ? void 0 : (_totalConnectorsRes$a3 = _totalConnectorsRes$a2.references) === null || _totalConnectorsRes$a3 === void 0 ? void 0 : (_totalConnectorsRes$a4 = _totalConnectorsRes$a3.referenceType) === null || _totalConnectorsRes$a4 === void 0 ? void 0 : (_totalConnectorsRes$a5 = _totalConnectorsRes$a4.referenceAgg) === null || _totalConnectorsRes$a5 === void 0 ? void 0 : _totalConnectorsRes$a5.value) !== null && _totalConnectorsRes$a !== void 0 ? _totalConnectorsRes$a : 0,
        latestDates,
        assignees: {
          total: (_casesRes$aggregation7 = (_casesRes$aggregation8 = casesRes.aggregations) === null || _casesRes$aggregation8 === void 0 ? void 0 : _casesRes$aggregation8.totalAssignees.value) !== null && _casesRes$aggregation7 !== void 0 ? _casesRes$aggregation7 : 0,
          totalWithZero: (_casesRes$aggregation9 = (_casesRes$aggregation10 = casesRes.aggregations) === null || _casesRes$aggregation10 === void 0 ? void 0 : _casesRes$aggregation10.assigneeFilters.buckets.zero.doc_count) !== null && _casesRes$aggregation9 !== void 0 ? _casesRes$aggregation9 : 0,
          totalWithAtLeastOne: (_casesRes$aggregation11 = (_casesRes$aggregation12 = casesRes.aggregations) === null || _casesRes$aggregation12 === void 0 ? void 0 : _casesRes$aggregation12.assigneeFilters.buckets.atLeastOne.doc_count) !== null && _casesRes$aggregation11 !== void 0 ? _casesRes$aggregation11 : 0
        },
        ...allAttachmentFrameworkStats
      },
      sec: (0, _utils.getSolutionValues)({
        caseAggregations: casesRes.aggregations,
        attachmentAggregations: commentsRes.aggregations,
        filesAggregations: filesRes.aggregations,
        owner: 'securitySolution'
      }),
      obs: (0, _utils.getSolutionValues)({
        caseAggregations: casesRes.aggregations,
        attachmentAggregations: commentsRes.aggregations,
        filesAggregations: filesRes.aggregations,
        owner: 'observability'
      }),
      main: (0, _utils.getSolutionValues)({
        caseAggregations: casesRes.aggregations,
        attachmentAggregations: commentsRes.aggregations,
        filesAggregations: filesRes.aggregations,
        owner: 'cases'
      })
    };
  } catch (error) {
    logger.error(`Cases telemetry failed with error: ${error}`);
    throw error;
  }
};
exports.getCasesTelemetryData = getCasesTelemetryData;
const getCasesSavedObjectTelemetry = async savedObjectsClient => {
  const caseByOwnerAggregationQuery = _constants.OWNERS.reduce((aggQuery, owner) => ({
    ...aggQuery,
    [owner]: {
      filter: {
        term: {
          [`${_constants.CASE_SAVED_OBJECT}.attributes.owner`]: owner
        }
      },
      aggs: {
        ...(0, _utils.getCountsAggregationQuery)(_constants.CASE_SAVED_OBJECT),
        ...getAssigneesAggregations()
      }
    }
  }), {});
  return savedObjectsClient.find({
    page: 0,
    perPage: 0,
    type: _constants.CASE_SAVED_OBJECT,
    aggs: {
      ...caseByOwnerAggregationQuery,
      ...(0, _utils.getCountsAggregationQuery)(_constants.CASE_SAVED_OBJECT),
      ...getAssigneesAggregations(),
      totalsByOwner: {
        terms: {
          field: `${_constants.CASE_SAVED_OBJECT}.attributes.owner`
        }
      },
      syncAlerts: {
        terms: {
          field: `${_constants.CASE_SAVED_OBJECT}.attributes.settings.syncAlerts`
        }
      },
      status: {
        terms: {
          field: `${_constants.CASE_SAVED_OBJECT}.attributes.status`
        }
      },
      users: {
        cardinality: {
          field: `${_constants.CASE_SAVED_OBJECT}.attributes.created_by.username`
        }
      },
      tags: {
        cardinality: {
          field: `${_constants.CASE_SAVED_OBJECT}.attributes.tags`
        }
      }
    }
  });
};
const getAssigneesAggregations = () => ({
  totalAssignees: {
    value_count: {
      field: `${_constants.CASE_SAVED_OBJECT}.attributes.assignees.uid`
    }
  },
  assigneeFilters: {
    filters: {
      filters: {
        zero: {
          bool: {
            must_not: {
              exists: {
                field: `${_constants.CASE_SAVED_OBJECT}.attributes.assignees.uid`
              }
            }
          }
        },
        atLeastOne: {
          bool: {
            filter: {
              exists: {
                field: `${_constants.CASE_SAVED_OBJECT}.attributes.assignees.uid`
              }
            }
          }
        }
      }
    }
  }
});
const getCommentsSavedObjectTelemetry = async savedObjectsClient => {
  const attachmentRegistries = () => ({
    externalReferenceTypes: {
      terms: {
        field: `${_constants.CASE_COMMENT_SAVED_OBJECT}.attributes.externalReferenceAttachmentTypeId`,
        size: 10
      },
      aggs: {
        ...(0, _utils.getMaxBucketOnCaseAggregationQuery)(_constants.CASE_COMMENT_SAVED_OBJECT)
      }
    },
    persistableReferenceTypes: {
      terms: {
        field: `${_constants.CASE_COMMENT_SAVED_OBJECT}.attributes.persistableStateAttachmentTypeId`,
        size: 10
      },
      aggs: {
        ...(0, _utils.getMaxBucketOnCaseAggregationQuery)(_constants.CASE_COMMENT_SAVED_OBJECT)
      }
    }
  });
  const attachmentsByOwnerAggregationQuery = _constants.OWNERS.reduce((aggQuery, owner) => ({
    ...aggQuery,
    [owner]: {
      filter: {
        term: {
          [`${_constants.CASE_COMMENT_SAVED_OBJECT}.attributes.owner`]: owner
        }
      },
      aggs: {
        ...attachmentRegistries()
      }
    }
  }), {});
  return savedObjectsClient.find({
    page: 0,
    perPage: 0,
    type: _constants.CASE_COMMENT_SAVED_OBJECT,
    aggs: {
      ...attachmentsByOwnerAggregationQuery,
      ...attachmentRegistries(),
      participants: {
        cardinality: {
          field: `${_constants.CASE_COMMENT_SAVED_OBJECT}.attributes.created_by.username`
        }
      }
    }
  });
};
const getFilesTelemetry = async savedObjectsClient => {
  const averageSize = () => ({
    averageSize: {
      avg: {
        field: `${_common.FILE_SO_TYPE}.attributes.size`
      }
    }
  });
  const top20MimeTypes = () => ({
    topMimeTypes: {
      terms: {
        field: `${_common.FILE_SO_TYPE}.attributes.mime_type`,
        size: 20
      }
    }
  });
  const filesByOwnerAggregationQuery = _constants.OWNERS.reduce((aggQuery, owner) => ({
    ...aggQuery,
    [owner]: {
      filter: {
        term: {
          [`${_common.FILE_SO_TYPE}.attributes.Meta.owner`]: owner
        }
      },
      aggs: {
        ...averageSize(),
        ...top20MimeTypes()
      }
    }
  }), {});
  const filterCaseIdExists = (0, _esQuery.fromKueryExpression)(`${_common.FILE_SO_TYPE}.attributes.Meta.caseIds: *`);
  return savedObjectsClient.find({
    page: 0,
    perPage: 0,
    type: _common.FILE_SO_TYPE,
    filter: filterCaseIdExists,
    aggs: {
      ...filesByOwnerAggregationQuery,
      ...averageSize(),
      ...top20MimeTypes()
    }
  });
};
const getAlertsTelemetry = async savedObjectsClient => {
  return savedObjectsClient.find({
    page: 0,
    perPage: 0,
    type: _constants.CASE_COMMENT_SAVED_OBJECT,
    filter: (0, _utils.getOnlyAlertsCommentsFilter)(),
    aggs: {
      ...(0, _utils.getReferencesAggregationQuery)({
        savedObjectType: _constants.CASE_COMMENT_SAVED_OBJECT,
        referenceType: 'cases',
        agg: 'cardinality'
      })
    }
  });
};
const getConnectorsTelemetry = async savedObjectsClient => {
  return savedObjectsClient.find({
    page: 0,
    perPage: 0,
    type: _constants.CASE_USER_ACTION_SAVED_OBJECT,
    filter: (0, _utils.getOnlyConnectorsFilter)(),
    aggs: {
      ...(0, _utils.getReferencesAggregationQuery)({
        savedObjectType: _constants.CASE_USER_ACTION_SAVED_OBJECT,
        referenceType: 'cases',
        agg: 'cardinality'
      })
    }
  });
};