"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesSystemActionData = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesSystemActionData = async ({
  savedObjectsClient
}) => {
  var _res$aggregations$cou, _res$aggregations, _res$aggregations$cou2, _res$aggregations$tot, _res$aggregations2, _res$aggregations2$to;
  const res = await savedObjectsClient.find({
    page: 1,
    perPage: 1,
    type: _constants.CASE_RULES_SAVED_OBJECT,
    aggs: {
      counterSum: {
        sum: {
          field: `${_constants.CASE_RULES_SAVED_OBJECT}.attributes.counter`
        }
      },
      totalRules: {
        cardinality: {
          field: `${_constants.CASE_RULES_SAVED_OBJECT}.attributes.rules.id`
        }
      }
    }
  });
  return {
    totalCasesCreated: (_res$aggregations$cou = (_res$aggregations = res.aggregations) === null || _res$aggregations === void 0 ? void 0 : (_res$aggregations$cou2 = _res$aggregations.counterSum) === null || _res$aggregations$cou2 === void 0 ? void 0 : _res$aggregations$cou2.value) !== null && _res$aggregations$cou !== void 0 ? _res$aggregations$cou : 0,
    totalRules: (_res$aggregations$tot = (_res$aggregations2 = res.aggregations) === null || _res$aggregations2 === void 0 ? void 0 : (_res$aggregations2$to = _res$aggregations2.totalRules) === null || _res$aggregations2$to === void 0 ? void 0 : _res$aggregations2$to.value) !== null && _res$aggregations$tot !== void 0 ? _res$aggregations$tot : 0
  };
};
exports.getCasesSystemActionData = getCasesSystemActionData;