"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAttributesToESModel = transformAttributesToESModel;
exports.transformFindResponseToExternalModel = transformFindResponseToExternalModel;
exports.transformSavedObjectToExternalModel = transformSavedObjectToExternalModel;
exports.transformUpdateResponseToExternalModel = transformUpdateResponseToExternalModel;
var _server = require("@kbn/actions-plugin/server");
var _constants = require("../../../common/constants");
var _domain = require("../../../common/types/domain");
var _constants2 = require("../../common/constants");
var _transform = require("../transform");
var _connector_reference_handler = require("../connector_reference_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/naming-convention */

function transformUpdateResponseToExternalModel(updatedCase) {
  var _updatedCase$attribut;
  const {
    connector,
    external_service,
    severity,
    status,
    total_alerts,
    total_comments,
    customFields,
    ...restUpdateAttributes
  } = (_updatedCase$attribut = updatedCase.attributes) !== null && _updatedCase$attribut !== void 0 ? _updatedCase$attribut : {
    total_alerts: -1,
    total_comments: -1
  };
  const transformedConnector = (0, _transform.transformESConnectorToExternalModel)({
    // if the saved object had an error the attributes field will not exist
    connector,
    references: updatedCase.references,
    referenceName: _constants2.CONNECTOR_ID_REFERENCE_NAME
  });
  let externalService;

  // if external_service is not defined then we don't want to include it in the response since it wasn't passed it as an
  // attribute to update
  if (external_service !== undefined) {
    externalService = transformESExternalService(external_service, updatedCase.references);
  }
  return {
    ...updatedCase,
    attributes: {
      ...restUpdateAttributes,
      ...((severity || severity === 0) && {
        severity: _constants2.SEVERITY_ESMODEL_TO_EXTERNAL[severity]
      }),
      ...((status || status === 0) && {
        status: _constants2.STATUS_ESMODEL_TO_EXTERNAL[status]
      }),
      ...(transformedConnector && {
        connector: transformedConnector
      }),
      // if externalService is null that means we intentionally updated it to null within ES so return that as a valid value
      ...(externalService !== undefined && {
        external_service: externalService
      }),
      ...(customFields !== undefined && {
        customFields: customFields
      })
    }
  };
}
function transformAttributesToESModel(caseAttributes) {
  const {
    connector,
    external_service,
    severity,
    status,
    ...restAttributes
  } = caseAttributes;
  const {
    connector_id: pushConnectorId,
    ...restExternalService
  } = external_service !== null && external_service !== void 0 ? external_service : {};
  const transformedConnector = {
    ...(connector && {
      connector: {
        name: connector.name,
        type: connector.type,
        fields: (0, _transform.transformFieldsToESModel)(connector)
      }
    })
  };
  const transformedExternalService = {
    ...(external_service ? {
      external_service: restExternalService
    } : external_service === null ? {
      external_service: null
    } : {})
  };
  return {
    attributes: {
      ...restAttributes,
      ...transformedConnector,
      ...transformedExternalService,
      ...(severity && {
        severity: _constants2.SEVERITY_EXTERNAL_TO_ESMODEL[severity]
      }),
      ...(status && {
        status: _constants2.STATUS_EXTERNAL_TO_ESMODEL[status]
      })
    },
    referenceHandler: buildReferenceHandler(connector === null || connector === void 0 ? void 0 : connector.id, pushConnectorId)
  };
}
function buildReferenceHandler(connectorId, pushConnectorId) {
  return new _connector_reference_handler.ConnectorReferenceHandler([{
    id: connectorId,
    name: _constants2.CONNECTOR_ID_REFERENCE_NAME,
    type: _server.ACTION_SAVED_OBJECT_TYPE
  }, {
    id: pushConnectorId,
    name: _constants2.PUSH_CONNECTOR_ID_REFERENCE_NAME,
    type: _server.ACTION_SAVED_OBJECT_TYPE
  }]);
}
function transformFindResponseToExternalModel(response) {
  return {
    ...response,
    saved_objects: response.saved_objects.map(so => ({
      ...so,
      ...transformSavedObjectToExternalModel(so)
    }))
  };
}
function transformSavedObjectToExternalModel(caseSavedObject) {
  var _caseSavedObject$attr, _caseSavedObject$attr2, _caseSavedObject$attr3, _SEVERITY_ESMODEL_TO_, _STATUS_ESMODEL_TO_EX;
  const connector = (0, _transform.transformESConnectorOrUseDefault)({
    // if the saved object had an error the attributes field will not exist
    connector: (_caseSavedObject$attr = caseSavedObject.attributes) === null || _caseSavedObject$attr === void 0 ? void 0 : _caseSavedObject$attr.connector,
    references: caseSavedObject.references,
    referenceName: _constants2.CONNECTOR_ID_REFERENCE_NAME
  });
  const externalService = transformESExternalService((_caseSavedObject$attr2 = caseSavedObject.attributes) === null || _caseSavedObject$attr2 === void 0 ? void 0 : _caseSavedObject$attr2.external_service, caseSavedObject.references);
  const {
    total_alerts,
    total_comments,
    ...caseSavedObjectAttributes
  } = (_caseSavedObject$attr3 = caseSavedObject.attributes) !== null && _caseSavedObject$attr3 !== void 0 ? _caseSavedObject$attr3 : {
    total_alerts: -1,
    total_comments: -1
  };
  const severity = (_SEVERITY_ESMODEL_TO_ = _constants2.SEVERITY_ESMODEL_TO_EXTERNAL[caseSavedObjectAttributes.severity]) !== null && _SEVERITY_ESMODEL_TO_ !== void 0 ? _SEVERITY_ESMODEL_TO_ : _domain.CaseSeverity.LOW;
  const status = (_STATUS_ESMODEL_TO_EX = _constants2.STATUS_ESMODEL_TO_EXTERNAL[caseSavedObjectAttributes.status]) !== null && _STATUS_ESMODEL_TO_EX !== void 0 ? _STATUS_ESMODEL_TO_EX : _domain.CaseStatuses.open;
  const category = !caseSavedObjectAttributes.category ? null : caseSavedObjectAttributes.category;
  const customFields = !caseSavedObjectAttributes.customFields ? [] : caseSavedObjectAttributes.customFields;
  return {
    ...caseSavedObject,
    attributes: {
      ...caseSavedObjectAttributes,
      severity,
      status,
      connector,
      external_service: externalService,
      category,
      customFields
    }
  };
}
function transformESExternalService(
// this type needs to match that of CaseFullExternalService except that it does not include the connector_id, see: x-pack/plugins/cases/common/api/cases/case.ts
// that's why it can be null here
externalService, references) {
  var _connectorIdRef$id;
  const connectorIdRef = (0, _transform.findConnectorIdReference)(_constants2.PUSH_CONNECTOR_ID_REFERENCE_NAME, references);
  if (!externalService) {
    return null;
  }
  return {
    ...externalService,
    connector_id: (_connectorIdRef$id = connectorIdRef === null || connectorIdRef === void 0 ? void 0 : connectorIdRef.id) !== null && _connectorIdRef$id !== void 0 ? _connectorIdRef$id : _constants.NONE_CONNECTOR_ID
  };
}