"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAttachmentsSubClient = void 0;
var _add = require("./add");
var _bulk_create = require("./bulk_create");
var _delete = require("./delete");
var _get = require("./get");
var _bulk_get = require("./bulk_get");
var _update = require("./update");
var _bulk_delete = require("./bulk_delete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * API for interacting with the attachments to a case.
 */

/**
 * Creates an API object for interacting with attachments.
 *
 * @ignore
 */
const createAttachmentsSubClient = (clientArgs, casesClient, casesClientInternal) => {
  const attachmentSubClient = {
    add: params => (0, _add.addComment)(params, clientArgs),
    bulkCreate: params => (0, _bulk_create.bulkCreate)(params, clientArgs),
    bulkGet: params => (0, _bulk_get.bulkGet)(params, clientArgs, casesClient),
    delete: params => (0, _delete.deleteComment)(params, clientArgs),
    deleteAll: params => (0, _delete.deleteAll)(params, clientArgs),
    bulkDeleteFileAttachments: params => (0, _bulk_delete.bulkDeleteFileAttachments)(params, clientArgs, casesClient),
    find: params => (0, _get.find)(params, clientArgs),
    getAllAlertsAttachToCase: params => (0, _get.getAllAlertsAttachToCase)(params, clientArgs, casesClient),
    getAll: params => (0, _get.getAll)(params, clientArgs),
    get: params => (0, _get.get)(params, clientArgs),
    update: params => (0, _update.update)(params, clientArgs)
  };
  return Object.freeze(attachmentSubClient);
};
exports.createAttachmentsSubClient = createAttachmentsSubClient;