"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postCaseConfigure = exports.patchCaseConfigure = exports.getSupportedActionConnectors = exports.getCaseConfigure = exports.fetchActionTypes = void 0;
var _fp = require("lodash/fp");
var _common = require("@kbn/actions-plugin/common");
var _connectors_api = require("../../../common/utils/connectors_api");
var _api = require("../../../common/api");
var _constants = require("../../../common/constants");
var _kibana = require("../../common/lib/kibana");
var _utils = require("../../api/utils");
var _utils2 = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSupportedActionConnectors = async ({
  signal
}) => {
  const response = await _kibana.KibanaServices.get().http.fetch(`${_constants.CASE_CONFIGURE_CONNECTORS_URL}/_find`, {
    method: 'GET',
    signal
  });
  return response;
};
exports.getSupportedActionConnectors = getSupportedActionConnectors;
const getCaseConfigure = async ({
  signal
}) => {
  const response = await _kibana.KibanaServices.get().http.fetch(_constants.CASE_CONFIGURE_URL, {
    method: 'GET',
    signal
  });
  if (!(0, _fp.isEmpty)(response)) {
    const decodedConfigs = (0, _utils2.decodeCaseConfigurationsResponse)(response);
    if (Array.isArray(decodedConfigs) && decodedConfigs.length > 0) {
      return decodedConfigs.map(decodedConfig => {
        const configuration = (0, _utils.convertToCamelCase)(decodedConfig);
        return convertConfigureResponseToCasesConfigure(configuration);
      });
    }
  }
  return null;
};
exports.getCaseConfigure = getCaseConfigure;
const postCaseConfigure = async caseConfiguration => {
  const response = await _kibana.KibanaServices.get().http.fetch(_constants.CASE_CONFIGURE_URL, {
    method: 'POST',
    body: JSON.stringify(caseConfiguration)
  });
  const configuration = (0, _utils.convertToCamelCase)((0, _utils2.decodeCaseConfigureResponse)(response));
  return convertConfigureResponseToCasesConfigure(configuration);
};
exports.postCaseConfigure = postCaseConfigure;
const patchCaseConfigure = async (id, caseConfiguration) => {
  const response = await _kibana.KibanaServices.get().http.fetch((0, _api.getCaseConfigurationDetailsUrl)(id), {
    method: 'PATCH',
    body: JSON.stringify(caseConfiguration)
  });
  const configuration = (0, _utils.convertToCamelCase)((0, _utils2.decodeCaseConfigureResponse)(response));
  return convertConfigureResponseToCasesConfigure(configuration);
};
exports.patchCaseConfigure = patchCaseConfigure;
const fetchActionTypes = async ({
  signal
}) => {
  const response = await _kibana.KibanaServices.get().http.fetch((0, _connectors_api.getAllConnectorTypesUrl)(), {
    method: 'GET',
    signal,
    query: {
      feature_id: _common.CasesConnectorFeatureId
    }
  });
  return (0, _utils.convertArrayToCamelCase)(response);
};
exports.fetchActionTypes = fetchActionTypes;
const convertConfigureResponseToCasesConfigure = configuration => {
  const {
    id,
    version,
    mappings,
    customFields,
    closureType,
    connector,
    owner
  } = configuration;
  return {
    id,
    version,
    mappings,
    customFields,
    closureType,
    connector,
    owner
  };
};