"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customFieldSerializer = exports.addOrReplaceCustomField = void 0;
var _string = require("@kbn/es-ui-shared-plugin/static/validators/string");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addOrReplaceCustomField = (customFields, customFieldToAdd) => {
  const foundCustomFieldIndex = customFields.findIndex(customField => customField.key === customFieldToAdd.key);
  if (foundCustomFieldIndex === -1) {
    return [...customFields, customFieldToAdd];
  }
  return customFields.map(customField => {
    if (customField.key !== customFieldToAdd.key) {
      return customField;
    }
    return customFieldToAdd;
  });
};
exports.addOrReplaceCustomField = addOrReplaceCustomField;
const customFieldSerializer = field => {
  const {
    defaultValue,
    ...otherProperties
  } = field;
  if (defaultValue === undefined || (0, _lodash.isString)(defaultValue) && (0, _string.isEmptyString)(defaultValue)) {
    return otherProperties;
  }
  return field;
};
exports.customFieldSerializer = customFieldSerializer;