"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Create = void 0;
var _react = _interopRequireDefault(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _config = require("./config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateComponent = ({
  customFieldConfiguration,
  isLoading
}) => {
  const {
    key,
    label,
    required,
    defaultValue
  } = customFieldConfiguration;
  const config = (0, _config.getTextFieldConfig)({
    required,
    label,
    ...(defaultValue && {
      defaultValue: String(defaultValue)
    })
  });
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `customFields.${key}`,
    config: config,
    component: _components.TextField,
    label: label,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': `${key}-text-create-custom-field`,
        fullWidth: true,
        disabled: isLoading,
        isLoading
      }
    }
  });
};
CreateComponent.displayName = 'Create';
const Create = exports.Create = /*#__PURE__*/_react.default.memo(CreateComponent);