"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemaTags = exports.schema = void 0;
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _optional_field_label = require("./optional_field_label");
var _translations2 = require("../severity/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  maxLengthField
} = _helpers.fieldValidators;
const isInvalidTag = value => value.trim() === '';
const isTagCharactersInLimit = value => value.trim().length > _constants.MAX_LENGTH_PER_TAG;
const schemaTags = exports.schemaTags = {
  type: _hook_form_lib.FIELD_TYPES.COMBO_BOX,
  label: i18n.TAGS,
  helpText: i18n.TAGS_HELP,
  labelAppend: _optional_field_label.OptionalFieldLabel,
  validations: [{
    validator: ({
      value
    }) => {
      if (!Array.isArray(value) && isInvalidTag(value) || Array.isArray(value) && value.length > 0 && value.find(isInvalidTag)) {
        return {
          message: i18n.TAGS_EMPTY_ERROR
        };
      }
    },
    type: _hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM,
    isBlocking: false
  }, {
    validator: ({
      value
    }) => {
      if (!Array.isArray(value) && isTagCharactersInLimit(value) || Array.isArray(value) && value.length > 0 && value.some(isTagCharactersInLimit)) {
        return {
          message: i18n.MAX_LENGTH_ERROR('tag', _constants.MAX_LENGTH_PER_TAG)
        };
      }
    },
    type: _hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM,
    isBlocking: false
  }, {
    validator: ({
      value
    }) => {
      if (Array.isArray(value) && value.length > _constants.MAX_TAGS_PER_CASE) {
        return {
          message: i18n.MAX_TAGS_ERROR(_constants.MAX_TAGS_PER_CASE)
        };
      }
    }
  }]
};
const schema = exports.schema = {
  title: {
    type: _hook_form_lib.FIELD_TYPES.TEXT,
    label: i18n.NAME,
    validations: [{
      validator: emptyField(i18n.TITLE_REQUIRED)
    }, {
      validator: maxLengthField({
        length: _constants.MAX_TITLE_LENGTH,
        message: i18n.MAX_LENGTH_ERROR('name', _constants.MAX_TITLE_LENGTH)
      })
    }]
  },
  description: {
    label: i18n.DESCRIPTION,
    validations: [{
      validator: emptyField(i18n.DESCRIPTION_REQUIRED)
    }, {
      validator: maxLengthField({
        length: _constants.MAX_DESCRIPTION_LENGTH,
        message: i18n.MAX_LENGTH_ERROR('description', _constants.MAX_DESCRIPTION_LENGTH)
      })
    }]
  },
  selectedOwner: {
    label: i18n.SOLUTION,
    type: _hook_form_lib.FIELD_TYPES.RADIO_GROUP,
    validations: [{
      validator: emptyField(i18n.SOLUTION_REQUIRED)
    }]
  },
  tags: schemaTags,
  severity: {
    label: _translations2.SEVERITY_TITLE
  },
  connectorId: {
    type: _hook_form_lib.FIELD_TYPES.SUPER_SELECT,
    label: i18n.CONNECTORS,
    defaultValue: 'none'
  },
  fields: {
    defaultValue: null
  },
  syncAlerts: {
    helpText: i18n.SYNC_ALERTS_HELP,
    type: _hook_form_lib.FIELD_TYPES.TOGGLE,
    defaultValue: true
  },
  assignees: {},
  category: {}
};