"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseOwnerSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _common = require("@kbn/kibana-react-plugin/common");
var _common2 = require("../../../common");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SELECTABLE_OWNERS = Object.keys(_constants.OWNER_INFO);
const FIELD_NAME = 'selectedOwner';
const FullWidthKeyPadMenu = (0, _common.euiStyled)(_eui.EuiKeyPadMenu)`
  width: 100%;
`;
const FullWidthKeyPadItem = (0, _common.euiStyled)(_eui.EuiKeyPadMenuItem)`

  width: 100%;
`;
const OwnerSelector = ({
  availableOwners,
  field,
  isLoading = false
}) => {
  const {
    errorMessage,
    isInvalid
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const radioGroupName = (0, _eui.useGeneratedHtmlId)({
    prefix: 'caseOwnerRadioGroup'
  });
  const onChange = (0, _react.useCallback)(val => field.setValue(val), [field]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "caseOwnerSelector",
    fullWidth: true,
    isInvalid: isInvalid,
    error: errorMessage,
    helpText: field.helpText,
    label: field.label,
    labelAppend: field.labelAppend
  }, /*#__PURE__*/_react.default.createElement(FullWidthKeyPadMenu, {
    checkable: {
      ariaLegend: i18n.ARIA_KEYPAD_LEGEND
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, DEFAULT_SELECTABLE_OWNERS.map(owner => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: owner
  }, /*#__PURE__*/_react.default.createElement(FullWidthKeyPadItem, {
    "data-test-subj": `${owner}RadioButton`,
    onChange: onChange,
    checkable: "single",
    name: radioGroupName,
    id: owner,
    label: _constants.OWNER_INFO[owner].label,
    isSelected: field.value === owner,
    isDisabled: isLoading || !availableOwners.includes(owner)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _constants.OWNER_INFO[owner].iconType,
    size: "xl"
  })))))));
};
OwnerSelector.displayName = 'OwnerSelector';
const CaseOwnerSelector = ({
  availableOwners,
  isLoading
}) => {
  var _availableOwners$;
  const defaultValue = availableOwners.includes(_common2.SECURITY_SOLUTION_OWNER) ? _common2.SECURITY_SOLUTION_OWNER : (_availableOwners$ = availableOwners[0]) !== null && _availableOwners$ !== void 0 ? _availableOwners$ : _common2.SECURITY_SOLUTION_OWNER;
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: FIELD_NAME,
    config: {
      defaultValue
    },
    component: OwnerSelector,
    componentProps: {
      availableOwners,
      isLoading
    }
  });
};
CaseOwnerSelector.displayName = 'CaseOwnerSelectionComponent';
const CreateCaseOwnerSelector = exports.CreateCaseOwnerSelector = /*#__PURE__*/(0, _react.memo)(CaseOwnerSelector);