"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _constants = require("../../../common/constants");
var _domain = require("../../../common/types/domain");
var _schema = require("./schema");
var _utils = require("../configure_cases/utils");
var _use_post_case = require("../../containers/use_post_case");
var _use_post_push_to_service = require("../../containers/use_post_push_to_service");
var _use_create_attachments = require("../../containers/use_create_attachments");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_cases_features = require("../../common/use_cases_features");
var _utils2 = require("../utils");
var _use_available_owners = require("../app/use_available_owners");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
var _use_cases_transactions = require("../../common/apm/use_cases_transactions");
var _use_get_all_case_configurations = require("../../containers/configure/use_get_all_case_configurations");
var _use_application = require("../../common/lib/kibana/use_application");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialCaseValue = {
  description: '',
  tags: [],
  title: '',
  severity: _domain.CaseSeverity.LOW,
  connectorId: _constants.NONE_CONNECTOR_ID,
  fields: null,
  syncAlerts: true,
  assignees: [],
  customFields: {}
};
const FormContext = ({
  afterCaseCreated,
  children,
  onSuccess,
  attachments,
  initialValue
}) => {
  const {
    data: connectors = [],
    isLoading: isLoadingConnectors
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const {
    data: allConfigurations
  } = (0, _use_get_all_case_configurations.useGetAllCaseConfigurations)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const {
    appId
  } = (0, _use_application.useApplication)();
  const {
    isSyncAlertsEnabled
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    mutateAsync: postCase
  } = (0, _use_post_case.usePostCase)();
  const {
    mutateAsync: createAttachments
  } = (0, _use_create_attachments.useCreateAttachments)();
  const {
    mutateAsync: pushCaseToExternalService
  } = (0, _use_post_push_to_service.usePostPushToService)();
  const {
    startTransaction
  } = (0, _use_cases_transactions.useCreateCaseWithAttachmentsTransaction)();
  const availableOwners = (0, _use_available_owners.useAvailableCasesOwners)();
  const trimUserFormData = userFormData => {
    let formData = {
      ...userFormData,
      title: userFormData.title.trim(),
      description: userFormData.description.trim()
    };
    if (userFormData.category) {
      formData = {
        ...formData,
        category: userFormData.category.trim()
      };
    }
    if (userFormData.tags) {
      formData = {
        ...formData,
        tags: userFormData.tags.map(tag => tag.trim())
      };
    }
    return formData;
  };
  const transformCustomFieldsData = (0, _react.useCallback)((customFields, selectedCustomFieldsConfiguration) => {
    const transformedCustomFields = [];
    if (!customFields || !selectedCustomFieldsConfiguration.length) {
      return [];
    }
    for (const [key, value] of Object.entries(customFields)) {
      const configCustomField = selectedCustomFieldsConfiguration.find(item => item.key === key);
      if (configCustomField) {
        transformedCustomFields.push({
          key: configCustomField.key,
          type: configCustomField.type,
          value: (0, _utils2.convertCustomFieldValue)(value)
        });
      }
    }
    return transformedCustomFields;
  }, []);
  const submitCase = (0, _react.useCallback)(async ({
    connectorId: dataConnectorId,
    fields,
    syncAlerts = isSyncAlertsEnabled,
    ...dataWithoutConnectorId
  }, isValid) => {
    if (isValid) {
      var _owner$;
      const {
        selectedOwner,
        customFields,
        ...userFormData
      } = dataWithoutConnectorId;
      const caseConnector = (0, _utils2.getConnectorById)(dataConnectorId, connectors);
      const defaultOwner = (_owner$ = owner[0]) !== null && _owner$ !== void 0 ? _owner$ : availableOwners[0];
      startTransaction({
        appId,
        attachments
      });
      const connectorToUpdate = caseConnector ? (0, _utils.normalizeActionConnector)(caseConnector, fields) : (0, _utils.getNoneConnector)();
      const configurationOwner = selectedOwner ? selectedOwner : owner[0];
      const selectedConfiguration = allConfigurations.find(element => element.owner === configurationOwner);
      const customFieldsConfiguration = selectedConfiguration ? selectedConfiguration.customFields : [];
      const transformedCustomFields = transformCustomFieldsData(customFields, customFieldsConfiguration !== null && customFieldsConfiguration !== void 0 ? customFieldsConfiguration : []);
      const trimmedData = trimUserFormData(userFormData);
      const theCase = await postCase({
        request: {
          ...trimmedData,
          connector: connectorToUpdate,
          settings: {
            syncAlerts
          },
          owner: selectedOwner !== null && selectedOwner !== void 0 ? selectedOwner : defaultOwner,
          customFields: transformedCustomFields
        }
      });

      // add attachments to the case
      if (theCase && Array.isArray(attachments) && attachments.length > 0) {
        await createAttachments({
          caseId: theCase.id,
          caseOwner: theCase.owner,
          attachments
        });
      }
      if (afterCaseCreated && theCase) {
        await afterCaseCreated(theCase, createAttachments);
      }
      if (theCase !== null && theCase !== void 0 && theCase.id && connectorToUpdate.id !== 'none') {
        await pushCaseToExternalService({
          caseId: theCase.id,
          connector: connectorToUpdate
        });
      }
      if (onSuccess && theCase) {
        onSuccess(theCase);
      }
    }
  }, [isSyncAlertsEnabled, connectors, owner, availableOwners, startTransaction, appId, attachments, transformCustomFieldsData, allConfigurations, postCase, afterCaseCreated, onSuccess, createAttachments, pushCaseToExternalService]);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      ...initialCaseValue,
      ...initialValue
    },
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema,
    onSubmit: submitCase,
    serializer: _utils2.getConnectorsFormSerializer,
    deserializer: _utils2.getConnectorsFormDeserializer
  });
  const childrenWithExtraProp = (0, _react.useMemo)(() => children != null ? _react.default.Children.map(children, child => /*#__PURE__*/_react.default.cloneElement(child, {
    connectors,
    isLoadingConnectors
  })) : null, [children, connectors, isLoadingConnectors]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    onKeyDown: e => {
      // It avoids the focus scaping from the flyout when enter is pressed.
      // https://github.com/elastic/kibana/issues/111120
      if (e.key === 'Enter') {
        e.stopPropagation();
      }
    },
    form: form
  }, childrenWithExtraProp);
};
exports.FormContext = FormContext;
FormContext.displayName = 'FormContext';