"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _builder = require("../custom_fields/builder");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_get_all_case_configurations = require("../../containers/configure/use_get_all_case_configurations");
var _utils = require("../../containers/configure/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFieldsComponent = ({
  isLoading
}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const [{
    selectedOwner
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['selectedOwner']
  });
  const {
    data: configurations,
    isLoading: isLoadingCaseConfiguration
  } = (0, _use_get_all_case_configurations.useGetAllCaseConfigurations)();
  const configurationOwner = selectedOwner ? selectedOwner : owner[0];
  const customFieldsConfiguration = (0, _react.useMemo)(() => {
    var _getConfigurationByOw;
    return (_getConfigurationByOw = (0, _utils.getConfigurationByOwner)({
      configurations,
      owner: configurationOwner
    }).customFields) !== null && _getConfigurationByOw !== void 0 ? _getConfigurationByOw : [];
  }, [configurations, configurationOwner]);
  const sortedCustomFields = (0, _react.useMemo)(() => sortCustomFieldsByLabel(customFieldsConfiguration), [customFieldsConfiguration]);
  const customFieldsComponents = sortedCustomFields.map(customField => {
    const customFieldFactory = _builder.builderMap[customField.type];
    const customFieldType = customFieldFactory().build();
    const CreateComponent = customFieldType.Create;
    return /*#__PURE__*/_react.default.createElement(CreateComponent, {
      isLoading: isLoading || isLoadingCaseConfiguration,
      customFieldConfiguration: customField,
      key: customField.key
    });
  });
  if (!customFieldsConfiguration.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.ADDITIONAL_FIELDS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "create-case-custom-fields"
  }, customFieldsComponents));
};
CustomFieldsComponent.displayName = 'CustomFields';
const CustomFields = exports.CustomFields = /*#__PURE__*/_react.default.memo(CustomFieldsComponent);
const sortCustomFieldsByLabel = configCustomFields => {
  return (0, _lodash.sortBy)(configCustomFields, configCustomField => {
    return configCustomField.label;
  });
};