"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategoryComponent = exports.CategoryComponent = /*#__PURE__*/_react.default.memo(({
  isLoading,
  onChange,
  category,
  availableCategories,
  isInvalid = false
}) => {
  const options = (0, _react.useMemo)(() => {
    return availableCategories.map(label => ({
      label
    }));
  }, [availableCategories]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(category != null ? [{
    label: category
  }] : []);
  const onComboChange = (0, _react.useCallback)(currentOptions => {
    var _currentOptions$;
    const value = (_currentOptions$ = currentOptions[0]) === null || _currentOptions$ === void 0 ? void 0 : _currentOptions$.label;
    setSelectedOptions(currentOptions);
    onChange(value);
  }, [onChange]);
  const onCreateOption = searchValue => {
    const normalizedSearchValue = searchValue.trim();
    const newOption = {
      label: normalizedSearchValue
    };
    onComboChange([newOption]);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    isLoading: isLoading,
    isDisabled: isLoading,
    isInvalid: isInvalid,
    options: options,
    "data-test-subj": "categories-list",
    selectedOptions: selectedOptions,
    onChange: onComboChange,
    onCreateOption: onCreateOption,
    "aria-label": "categories-list",
    isClearable: true,
    customOptionText: _translations.ADD_CATEGORY_CUSTOM_OPTION_LABEL_COMBO_BOX,
    isCaseSensitive: true
  });
});
CategoryComponent.displayName = 'CategoryComponent';