"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CaseViewLoading = exports.CaseView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_get_case = require("../../containers/use_get_case");
var i18n = _interopRequireWildcard(require("./translations"));
var _timeline_context = require("../timeline_context");
var _does_not_exist = require("./does_not_exist");
var _kibana = require("../../common/lib/kibana");
var _use_cases_context = require("../cases_context/use_cases_context");
var _navigation = require("../../common/navigation");
var _case_view_page = require("./case_view_page");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseViewLoading = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "none",
  justifyContent: "center",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  "data-test-subj": "case-view-loading",
  size: "xl"
})));
exports.CaseViewLoading = CaseViewLoading;
const CaseView = exports.default = exports.CaseView = /*#__PURE__*/_react.default.memo(({
  actionsNavigation,
  ruleDetailsNavigation,
  showAlertDetails,
  timelineIntegration,
  useFetchAlertData,
  refreshRef
}) => {
  const {
    spaces: spacesApi
  } = (0, _kibana.useKibana)().services;
  const {
    detailName: caseId
  } = (0, _navigation.useCaseViewParams)();
  const {
    basePath
  } = (0, _use_cases_context.useCasesContext)();
  const {
    data,
    isLoading,
    isError,
    refetch
  } = (0, _use_get_case.useGetCase)(caseId);
  (0, _react.useEffect)(() => {
    if (spacesApi && (data === null || data === void 0 ? void 0 : data.outcome) === 'aliasMatch' && data.aliasTargetId != null) {
      const newPath = `${basePath}${(0, _navigation.generateCaseViewPath)({
        detailName: data.aliasTargetId
      })}`;
      spacesApi.ui.redirectLegacyUrl({
        path: `${newPath}${window.location.search}${window.location.hash}`,
        aliasPurpose: data.aliasPurpose,
        objectNoun: i18n.CASE
      });
    }
  }, [basePath, data, spacesApi]);
  const getLegacyUrlConflictCallout = (0, _react.useCallback)(() => {
    // This function returns a callout component *if* we have encountered a "legacy URL conflict" scenario
    if (data && spacesApi && data.outcome === 'conflict' && data.aliasTargetId != null) {
      // We have resolved to one object, but another object has a legacy URL alias associated with this ID/page. We should display a
      // callout with a warning for the user, and provide a way for them to navigate to the other object.
      const otherObjectPath = `${basePath}${(0, _navigation.generateCaseViewPath)({
        detailName: data.aliasTargetId
      })}${window.location.search}${window.location.hash}`;
      return spacesApi.ui.components.getLegacyUrlConflict({
        objectNoun: i18n.CASE,
        currentObjectId: data.case.id,
        otherObjectId: data.aliasTargetId,
        otherObjectPath
      });
    }
    return null;
  }, [basePath, data, spacesApi]);
  return isError ? /*#__PURE__*/_react.default.createElement(_does_not_exist.DoesNotExist, {
    caseId: caseId
  }) : isLoading ? /*#__PURE__*/_react.default.createElement(CaseViewLoading, null) : data ? /*#__PURE__*/_react.default.createElement(_timeline_context.CasesTimelineIntegrationProvider, {
    timelineIntegration: timelineIntegration
  }, getLegacyUrlConflictCallout(), /*#__PURE__*/_react.default.createElement(_case_view_page.CaseViewPage, {
    caseData: data.case,
    fetchCase: refetch,
    actionsNavigation: actionsNavigation,
    ruleDetailsNavigation: ruleDetailsNavigation,
    showAlertDetails: showAlertDetails,
    useFetchAlertData: useFetchAlertData,
    refreshRef: refreshRef
  })) : null;
});
CaseViewLoading.displayName = 'CaseViewLoading';
CaseView.displayName = 'CaseView';

// eslint-disable-next-line import/no-default-export