"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewAlerts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _constants = require("../../../../common/constants");
var _kibana = require("../../../common/lib/kibana");
var _helpers = require("./helpers");
var _use_get_feature_ids = require("../../../containers/use_get_feature_ids");
var _case_view_alerts_empty = require("./case_view_alerts_empty");
var _case_view_tabs = require("../case_view_tabs");
var _types = require("../../../../common/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseViewAlerts = ({
  caseData
}) => {
  var _alertData$ruleTypeId;
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  const alertIds = (0, _helpers.getManualAlertIds)(caseData.comments);
  const alertIdsQuery = (0, _react.useMemo)(() => ({
    ids: {
      values: alertIds
    }
  }), [alertIds]);
  const {
    isLoading: isLoadingAlertFeatureIds,
    data: alertData
  } = (0, _use_get_feature_ids.useGetFeatureIds)(alertIds, caseData.owner !== _constants.SECURITY_SOLUTION_OWNER);
  const configId = caseData.owner === _constants.SECURITY_SOLUTION_OWNER ? `${caseData.owner}-case` : !isLoadingAlertFeatureIds ? triggersActionsUi.alertsTableConfigurationRegistry.getAlertConfigIdPerRuleTypes((_alertData$ruleTypeId = alertData === null || alertData === void 0 ? void 0 : alertData.ruleTypeIds) !== null && _alertData$ruleTypeId !== void 0 ? _alertData$ruleTypeId : []) : '';
  const alertStateProps = (0, _react.useMemo)(() => {
    var _alertData$featureIds;
    return {
      alertsTableConfigurationRegistry: triggersActionsUi.alertsTableConfigurationRegistry,
      configurationId: configId,
      id: `case-details-alerts-${caseData.owner}`,
      featureIds: caseData.owner === _constants.SECURITY_SOLUTION_OWNER ? [_technical_rule_data_field_names.AlertConsumers.SIEM] : (_alertData$featureIds = alertData === null || alertData === void 0 ? void 0 : alertData.featureIds) !== null && _alertData$featureIds !== void 0 ? _alertData$featureIds : [],
      query: alertIdsQuery,
      showAlertStatusWithFlapping: caseData.owner !== _constants.SECURITY_SOLUTION_OWNER
    };
  }, [triggersActionsUi.alertsTableConfigurationRegistry, configId, caseData.owner, alertData === null || alertData === void 0 ? void 0 : alertData.featureIds, alertIdsQuery]);
  if (alertIdsQuery.ids.values.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
      caseData: caseData,
      activeTab: _types.CASE_VIEW_PAGE_TABS.ALERTS
    }), /*#__PURE__*/_react.default.createElement(_case_view_alerts_empty.CaseViewAlertsEmpty, null)));
  }
  return isLoadingAlertFeatureIds ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-view-alerts"
  }, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
    caseData: caseData,
    activeTab: _types.CASE_VIEW_PAGE_TABS.ALERTS
  }), triggersActionsUi.getAlertsStateTable(alertStateProps));
};
exports.CaseViewAlerts = CaseViewAlerts;
CaseViewAlerts.displayName = 'CaseViewAlerts';