"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../common/types");
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
var _case_action_bar = require("../case_action_bar");
var _header_page = require("../header_page");
var _editable_title = require("../header_page/editable_title");
var _use_timeline_context = require("../timeline_context/use_timeline_context");
var _use_breadcrumbs = require("../use_breadcrumbs");
var _case_view_activity = require("./components/case_view_activity");
var _case_view_alerts = require("./components/case_view_alerts");
var _case_view_files = require("./components/case_view_files");
var _metrics = require("./metrics");
var _use_on_refresh_case_view_page = require("./use_on_refresh_case_view_page");
var _use_on_update_field = require("./use_on_update_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActiveTabId = tabId => {
  if (tabId && Object.values(_types.CASE_VIEW_PAGE_TABS).includes(tabId)) {
    return tabId;
  }
  return _types.CASE_VIEW_PAGE_TABS.ACTIVITY;
};
const CaseViewPage = exports.CaseViewPage = /*#__PURE__*/_react.default.memo(({
  caseData,
  refreshRef,
  ruleDetailsNavigation,
  actionsNavigation,
  showAlertDetails,
  useFetchAlertData
}) => {
  var _useTimelineContext;
  const {
    features
  } = (0, _use_cases_context.useCasesContext)();
  const {
    urlParams
  } = (0, _navigation.useUrlParams)();
  const refreshCaseViewPage = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  (0, _use_breadcrumbs.useCasesTitleBreadcrumbs)(caseData.title);
  const activeTabId = getActiveTabId(urlParams === null || urlParams === void 0 ? void 0 : urlParams.tabId);
  const timelineUi = (_useTimelineContext = (0, _use_timeline_context.useTimelineContext)()) === null || _useTimelineContext === void 0 ? void 0 : _useTimelineContext.ui;
  const {
    onUpdateField,
    isLoading,
    loadingKey
  } = (0, _use_on_update_field.useOnUpdateField)({
    caseData
  });

  // Set `refreshRef` if needed
  (0, _react.useEffect)(() => {
    let isStale = false;
    if (refreshRef) {
      refreshRef.current = {
        refreshCase: async () => {
          // Do nothing if component (or instance of this render cycle) is stale or it is already loading
          if (isStale || isLoading) {
            return;
          }
          refreshCaseViewPage();
        }
      };
      return () => {
        isStale = true;
        refreshRef.current = null;
      };
    }
  }, [isLoading, refreshRef, refreshCaseViewPage]);
  const onSubmitTitle = (0, _react.useCallback)(newTitle => onUpdateField({
    key: 'title',
    value: newTitle
  }), [onUpdateField]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: false,
    showBackButton: true,
    "data-test-subj": "case-view-title",
    titleNode: /*#__PURE__*/_react.default.createElement(_editable_title.EditableTitle, {
      isLoading: isLoading && loadingKey === 'title',
      title: caseData.title,
      onSubmit: onSubmitTitle
    }),
    title: caseData.title
  }, /*#__PURE__*/_react.default.createElement(_case_action_bar.CaseActionBar, {
    caseData: caseData,
    isLoading: isLoading && (loadingKey === 'status' || loadingKey === 'settings'),
    onUpdateField: onUpdateField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_metrics.CaseViewMetrics, {
    "data-test-subj": "case-view-metrics",
    caseId: caseData.id
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `case-view-tab-content-${activeTabId}`,
    alignItems: "baseline"
  }, activeTabId === _types.CASE_VIEW_PAGE_TABS.ACTIVITY && /*#__PURE__*/_react.default.createElement(_case_view_activity.CaseViewActivity, {
    ruleDetailsNavigation: ruleDetailsNavigation,
    caseData: caseData,
    actionsNavigation: actionsNavigation,
    showAlertDetails: showAlertDetails,
    useFetchAlertData: useFetchAlertData
  }), activeTabId === _types.CASE_VIEW_PAGE_TABS.ALERTS && features.alerts.enabled && /*#__PURE__*/_react.default.createElement(_case_view_alerts.CaseViewAlerts, {
    caseData: caseData
  }), activeTabId === _types.CASE_VIEW_PAGE_TABS.FILES && /*#__PURE__*/_react.default.createElement(_case_view_files.CaseViewFiles, {
    caseData: caseData
  })), timelineUi !== null && timelineUi !== void 0 && timelineUi.renderTimelineDetailsPanel ? timelineUi.renderTimelineDetailsPanel() : null);
});
CaseViewPage.displayName = 'CaseViewPage';