"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesAddToExistingCaseModal = void 0;
var _react = require("react");
var _use_application = require("../../../common/lib/kibana/use_application");
var _domain = require("../../../../common/types/domain");
var _use_cases_toast = require("../../../common/use_cases_toast");
var _cases_context_reducer = require("../../cases_context/cases_context_reducer");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _use_cases_add_to_new_case_flyout = require("../../create/flyout/use_cases_add_to_new_case_flyout");
var _use_create_attachments = require("../../../containers/use_create_attachments");
var _use_cases_transactions = require("../../../common/apm/use_cases_transactions");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesAddToExistingCaseModal = ({
  successToaster,
  noAttachmentsToaster,
  onSuccess,
  onClose,
  onCreateCaseClicked
} = {}) => {
  const handleSuccess = (0, _react.useCallback)(theCase => {
    if (onSuccess && theCase) {
      return onSuccess(theCase);
    }
  }, [onSuccess]);
  const {
    open: openCreateNewCaseFlyout
  } = (0, _use_cases_add_to_new_case_flyout.useCasesAddToNewCaseFlyout)({
    onClose,
    onSuccess: handleSuccess,
    toastTitle: successToaster === null || successToaster === void 0 ? void 0 : successToaster.title,
    toastContent: successToaster === null || successToaster === void 0 ? void 0 : successToaster.content
  });
  const {
    dispatch
  } = (0, _use_cases_context.useCasesContext)();
  const {
    appId
  } = (0, _use_application.useApplication)();
  const casesToasts = (0, _use_cases_toast.useCasesToast)();
  const {
    mutateAsync: createAttachments
  } = (0, _use_create_attachments.useCreateAttachments)();
  const {
    startTransaction
  } = (0, _use_cases_transactions.useAddAttachmentToExistingCaseTransaction)();
  const closeModal = (0, _react.useCallback)(() => {
    dispatch({
      type: _cases_context_reducer.CasesContextStoreActionsList.CLOSE_ADD_TO_CASE_MODAL
    });
    // in case the flyout was also open when selecting
    // create a new case
    dispatch({
      type: _cases_context_reducer.CasesContextStoreActionsList.CLOSE_CREATE_CASE_FLYOUT
    });
  }, [dispatch]);
  const handleOnRowClick = (0, _react.useCallback)(async (theCase, getAttachments) => {
    var _getAttachments;
    const attachments = (_getAttachments = getAttachments === null || getAttachments === void 0 ? void 0 : getAttachments({
      theCase
    })) !== null && _getAttachments !== void 0 ? _getAttachments : [];

    // when the case is undefined in the modal
    // the user clicked "create new case"
    if (theCase === undefined) {
      closeModal();
      openCreateNewCaseFlyout({
        attachments
      });
      return;
    }
    try {
      // add attachments to the case
      if (attachments === undefined || attachments.length === 0) {
        var _noAttachmentsToaster;
        const title = (_noAttachmentsToaster = noAttachmentsToaster === null || noAttachmentsToaster === void 0 ? void 0 : noAttachmentsToaster.title) !== null && _noAttachmentsToaster !== void 0 ? _noAttachmentsToaster : _translations.NO_ATTACHMENTS_ADDED;
        const content = noAttachmentsToaster === null || noAttachmentsToaster === void 0 ? void 0 : noAttachmentsToaster.content;
        casesToasts.showInfoToast(title, content);
        return;
      }
      startTransaction({
        appId,
        attachments
      });
      await createAttachments({
        caseId: theCase.id,
        caseOwner: theCase.owner,
        attachments
      });
      onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(theCase);
      casesToasts.showSuccessAttach({
        theCase,
        attachments,
        title: successToaster === null || successToaster === void 0 ? void 0 : successToaster.title,
        content: successToaster === null || successToaster === void 0 ? void 0 : successToaster.content
      });
    } catch (error) {
      // error toast is handled
      // inside the createAttachments method
    }
  }, [appId, casesToasts, closeModal, createAttachments, openCreateNewCaseFlyout, successToaster === null || successToaster === void 0 ? void 0 : successToaster.title, successToaster === null || successToaster === void 0 ? void 0 : successToaster.content, noAttachmentsToaster === null || noAttachmentsToaster === void 0 ? void 0 : noAttachmentsToaster.title, noAttachmentsToaster === null || noAttachmentsToaster === void 0 ? void 0 : noAttachmentsToaster.content, onSuccess, startTransaction]);
  const openModal = (0, _react.useCallback)(({
    getAttachments
  } = {}) => {
    dispatch({
      type: _cases_context_reducer.CasesContextStoreActionsList.OPEN_ADD_TO_CASE_MODAL,
      payload: {
        hiddenStatuses: [_domain.CaseStatuses.closed],
        onCreateCaseClicked,
        onRowClick: theCase => {
          handleOnRowClick(theCase, getAttachments);
        },
        onClose: (theCase, isCreateCase) => {
          closeModal();
          if (onClose) {
            return onClose(theCase, isCreateCase);
          }
        }
      }
    });
  }, [closeModal, dispatch, handleOnRowClick, onClose, onCreateCaseClicked]);
  return (0, _react.useMemo)(() => {
    return {
      open: openModal,
      close: closeModal
    };
  }, [openModal, closeModal]);
};
exports.useCasesAddToExistingCaseModal = useCasesAddToExistingCaseModal;