"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineContextMock = exports.timelineIntegrationMock = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_timeline_context = require("../timeline_context/use_timeline_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

jest.mock('../timeline_context');
const mockTimelineComponent = name => /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": name
}, name);
const timelineIntegrationMock = exports.timelineIntegrationMock = {
  editor_plugins: {
    parsingPlugin: jest.fn(),
    processingPluginRenderer: () => mockTimelineComponent('plugin-renderer'),
    uiPlugin: {
      name: 'mock-timeline',
      button: {
        label: 'mock-timeline-button',
        iconType: 'mock-timeline-icon'
      },
      editor: () => mockTimelineComponent('plugin-timeline-editor')
    }
  },
  hooks: {
    useInsertTimeline: jest.fn()
  },
  ui: {
    renderTimelineDetailsPanel: () => mockTimelineComponent('timeline-details-panel')
  }
};
const useTimelineContextMock = exports.useTimelineContextMock = _use_timeline_context.useTimelineContext;