"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testQueryClient = exports.mockedTestProvidersOwner = exports.createAppMockRenderer = exports.TestProviders = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _react2 = require("@emotion/react");
var _react3 = require("@testing-library/react");
var _uiTheme = require("@kbn/ui-theme");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxFileMocks = require("@kbn/shared-ux-file-mocks");
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _constants = require("../../../common/constants");
var _cases_context = require("../../components/cases_context");
var _kibana_react = require("../lib/kibana/kibana_react.mock");
var _external_reference_registry = require("../../client/attachment_framework/external_reference_registry");
var _persistable_state_registry = require("../../client/attachment_framework/persistable_state_registry");
var _permissions = require("./permissions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable no-console */

window.scrollTo = jest.fn();
const mockGetFilesClient = () => {
  const mockedFilesClient = (0, _sharedUxFileMocks.createMockFilesClient)();
  mockedFilesClient.getFileKind.mockImplementation(() => ({
    id: 'test',
    maxSizeBytes: 10000,
    http: {}
  }));
  return () => mockedFilesClient;
};
const mockedTestProvidersOwner = exports.mockedTestProvidersOwner = [_constants.SECURITY_SOLUTION_OWNER];

/** A utility for wrapping children in the providers required to run most tests */
const TestProvidersComponent = ({
  children,
  features,
  owner = mockedTestProvidersOwner,
  permissions = (0, _permissions.allCasesPermissions)(),
  releasePhase = 'ga',
  externalReferenceAttachmentTypeRegistry = new _external_reference_registry.ExternalReferenceAttachmentTypeRegistry(),
  persistableStateAttachmentTypeRegistry = new _persistable_state_registry.PersistableStateAttachmentTypeRegistry(),
  license
}) => {
  const services = (0, _kibana_react.createStartServicesMock)({
    license
  });
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    },
    logger: {
      log: console.log,
      warn: console.warn,
      error: () => {}
    }
  });
  const getFilesClient = mockGetFilesClient();
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_react2.ThemeProvider, {
    theme: () => ({
      eui: _uiTheme.euiDarkVars,
      darkMode: true
    })
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.MemoryRouter, null, /*#__PURE__*/_react.default.createElement(_cases_context.CasesProvider, {
    value: {
      externalReferenceAttachmentTypeRegistry,
      persistableStateAttachmentTypeRegistry,
      features,
      owner,
      permissions,
      getFilesClient
    },
    queryClient: queryClient
  }, /*#__PURE__*/_react.default.createElement(_sharedUxFileContext.FilesContext, {
    client: (0, _sharedUxFileMocks.createMockFilesClient)()
  }, children))))));
};
TestProvidersComponent.displayName = 'TestProviders';
const TestProviders = exports.TestProviders = /*#__PURE__*/_react.default.memo(TestProvidersComponent);
const testQueryClient = exports.testQueryClient = new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      retry: false
    }
  },
  /**
   * React query prints the errors in the console even though
   * all tests are passings. We turn them off for testing.
   */
  logger: {
    log: console.log,
    warn: console.warn,
    error: () => {}
  }
});
const createAppMockRenderer = ({
  features,
  owner = mockedTestProvidersOwner,
  permissions = (0, _permissions.allCasesPermissions)(),
  releasePhase = 'ga',
  externalReferenceAttachmentTypeRegistry = new _external_reference_registry.ExternalReferenceAttachmentTypeRegistry(),
  persistableStateAttachmentTypeRegistry = new _persistable_state_registry.PersistableStateAttachmentTypeRegistry(),
  license
} = {}) => {
  const services = (0, _kibana_react.createStartServicesMock)({
    license
  });
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    },
    logger: {
      log: console.log,
      warn: console.warn,
      error: () => {}
    }
  });
  const getFilesClient = mockGetFilesClient();
  const AppWrapper = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_react2.ThemeProvider, {
    theme: () => ({
      eui: _uiTheme.euiDarkVars,
      darkMode: true
    })
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.MemoryRouter, null, /*#__PURE__*/_react.default.createElement(_cases_context.CasesProvider, {
    value: {
      externalReferenceAttachmentTypeRegistry,
      persistableStateAttachmentTypeRegistry,
      features,
      owner,
      permissions,
      releasePhase,
      getFilesClient
    },
    queryClient: queryClient
  }, children)))));
  AppWrapper.displayName = 'AppWrapper';
  const render = (ui, options) => {
    return (0, _react3.render)(ui, {
      wrapper: AppWrapper,
      ...options
    });
  };
  return {
    coreStart: services,
    queryClient,
    render,
    AppWrapper,
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry,
    getFilesClient
  };
};
exports.createAppMockRenderer = createAppMockRenderer;