"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stylePage = exports.setPageTransition = exports.setPage = exports.removePage = exports.movePage = exports.duplicatePage = exports.addPage = void 0;
var _reduxActions = require("redux-actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addPage = exports.addPage = (0, _reduxActions.createAction)('addPage');
const duplicatePage = exports.duplicatePage = (0, _reduxActions.createAction)('duplicatePage');
const movePage = exports.movePage = (0, _reduxActions.createAction)('movePage', (id, position, gotoPage) => ({
  id,
  position,
  gotoPage
}));
const removePage = exports.removePage = (0, _reduxActions.createAction)('removePage');
const stylePage = exports.stylePage = (0, _reduxActions.createAction)('stylePage', (pageId, style) => ({
  pageId,
  style
}));
const setPage = exports.setPage = (0, _reduxActions.createAction)('setPage');
const setPageTransition = exports.setPageTransition = (0, _reduxActions.createAction)('setPageTransition', (pageId, transition) => ({
  pageId,
  transition
}));