"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.expressionsServiceFactory = exports.ExpressionsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _interpreter = require("@kbn/interpreter");
var _rxjs = require("rxjs");
var _build_embeddable_filters = require("../../../common/lib/build_embeddable_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ExpressionsService {
  constructor(expressions, {
    filters,
    notify
  }) {
    (0, _defineProperty2.default)(this, "filters", void 0);
    (0, _defineProperty2.default)(this, "notify", void 0);
    this.expressions = expressions;
    this.filters = filters;
    this.notify = notify;
  }
  async interpretAst(ast, variables, input = null) {
    const context = await this.getGlobalContext();
    return await this.interpretAstWithContext(ast, input, {
      ...(context !== null && context !== void 0 ? context : {}),
      variables
    });
  }
  async interpretAstWithContext(ast, input = null, context) {
    return await this.expressions.execute(ast, input, {
      ...context,
      namespace: 'canvas'
    }).getData().pipe((0, _rxjs.pluck)('result')).toPromise();
  }

  /**
   * Runs interpreter, usually in the browser
   *
   * @param {object} ast - Executable AST
   * @param {any} input - Initial input for AST execution
   * @param {object} variables - Variables to pass in to the intrepreter context
   * @param {object} options
   * @param {boolean} options.castToRender - try to cast to a type: render object?
   * @returns {Promise<ExpressionValue>}
   */
  async runInterpreter(ast, input, variables, options = {}) {
    const context = await this.getGlobalContext();
    const fullContext = {
      ...(context !== null && context !== void 0 ? context : {}),
      variables
    };
    try {
      const renderable = await this.interpretAstWithContext(ast, input, fullContext);
      if ((0, _interpreter.getType)(renderable) === 'render') {
        return renderable;
      }
      if (options.castToRender) {
        return this.runInterpreter((0, _interpreter.fromExpression)('render'), renderable, fullContext, {
          castToRender: false
        });
      }
      throw new Error(`Ack! I don't know how to render a '${(0, _interpreter.getType)(renderable)}'`);
    } catch (err) {
      this.notify.error(err);
      throw err;
    }
  }
  getRenderer(name) {
    return this.expressions.getRenderer(name);
  }
  getFunctions() {
    return this.expressions.getFunctions();
  }
  async getFilters() {
    const filtersList = this.filters.getFilters();
    const context = this.filters.getFiltersContext();
    const filterExpression = filtersList.join(' | ');
    const filterAST = (0, _interpreter.fromExpression)(filterExpression);
    return await this.interpretAstWithContext(filterAST, null, context);
  }
  async getGlobalContext() {
    const canvasFilters = await this.getFilters();
    const kibanaFilters = (0, _build_embeddable_filters.buildEmbeddableFilters)(canvasFilters ? canvasFilters.and : []);
    return {
      searchContext: {
        ...kibanaFilters
      }
    };
  }
}
exports.ExpressionsService = ExpressionsService;
const expressionsServiceFactory = ({
  startPlugins
}, requiredServices) => new ExpressionsService(startPlugins.expressions, requiredServices);
exports.expressionsServiceFactory = expressionsServiceFactory;