"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.containerStyle = void 0;
var _reactRecompose = require("react-recompose");
var _objectPathImmutable = _interopRequireDefault(require("object-path-immutable"));
var _lodash = require("lodash");
var _template_from_react_component = require("../../../lib/template_from_react_component");
var _simple_template = require("./simple_template");
var _extended_template = require("./extended_template");
var _i18n = require("../../../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  set
} = _objectPathImmutable.default;
const {
  ContainerStyle: strings
} = _i18n.ArgTypesStrings;
const wrap = Component =>
// TODO: this should be in a helper
(0, _reactRecompose.withHandlers)({
  getArgValue: ({
    argValue
  }) => (name, alt) => {
    const args = (0, _lodash.get)(argValue, 'chain.0.arguments', {});
    return (0, _lodash.get)(args, `${name}.0`, alt);
  },
  setArgValue: ({
    argValue,
    onValueChange
  }) => (name, val) => {
    const newValue = set(argValue, `chain.0.arguments.${name}.0`, val);
    onValueChange(newValue);
  }
})(Component);
const containerStyle = () => ({
  name: 'containerStyle',
  displayName: strings.getDisplayName(),
  help: strings.getHelp(),
  default: '{containerStyle}',
  simpleTemplate: (0, _template_from_react_component.templateFromReactComponent)(wrap(_simple_template.SimpleTemplate)),
  template: (0, _template_from_react_component.templateFromReactComponent)(wrap(_extended_template.ExtendedTemplate))
});
exports.containerStyle = containerStyle;