"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabsControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/presentation-util-plugin/public");
var _services = require("../../../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getLabsButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderLabsControlSettings.labsButtonLabel', {
    defaultMessage: 'Labs'
  })
};
const Flyout = (0, _public.withSuspense)(_public.LazyLabsFlyout, null);
const LabsControl = () => {
  const {
    isLabsEnabled,
    getProjects
  } = (0, _services.useLabsService)();
  const [isShown, setIsShown] = (0, _react.useState)(false);
  if (!isLabsEnabled()) {
    return null;
  }
  const projects = getProjects(['canvas']);
  const overrideCount = Object.values(projects).filter(project => project.status.isOverride).length;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setIsShown(!isShown),
    size: "xs"
  }, strings.getLabsButtonLabel(), overrideCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    style: {
      marginLeft: 4
    }
  }, overrideCount) : null), isShown ? /*#__PURE__*/_react.default.createElement(Flyout, {
    solutions: ['canvas'],
    onClose: () => setIsShown(false)
  }) : null);
};
exports.LabsControl = LabsControl;