"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServices = getServices;
var _services = require("../../collectors/services");
var _parse_ean = require("../../parse_ean");
var _validate_date_range = require("../../validators/validate_date_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServices(options) {
  var _options$filters, _options$filters2, _options$filters4, _options$filters5, _options$filters6;
  (0, _validate_date_range.validateStringDateRange)(options.from, options.to);
  const filters = [];
  if ((_options$filters = options.filters) !== null && _options$filters !== void 0 && _options$filters.ean) {
    const eans = Array.isArray(options.filters.ean) ? options.filters.ean : [options.filters.ean];
    const services = eans.map(_parse_ean.parseEan).filter(({
      kind
    }) => kind === 'service').map(({
      id
    }) => id);
    if (services.length === 0) {
      return {
        services: []
      };
    }
    filters.push({
      terms: {
        'service.name': services
      }
    });
  }
  if ((_options$filters2 = options.filters) !== null && _options$filters2 !== void 0 && _options$filters2.parentEan) {
    var _options$filters3;
    const {
      kind,
      id
    } = (0, _parse_ean.parseEan)((_options$filters3 = options.filters) === null || _options$filters3 === void 0 ? void 0 : _options$filters3.parentEan);
    if (kind === 'host') {
      filters.push({
        bool: {
          should: [{
            term: {
              'host.name': id
            }
          }, {
            term: {
              'host.hostname': id
            }
          }],
          minimum_should_match: 1
        }
      });
    }
    if (kind === 'container') {
      filters.push({
        bool: {
          should: [{
            term: {
              'container.id': id
            }
          }],
          minimum_should_match: 1
        }
      });
    }
  }
  if ((_options$filters4 = options.filters) !== null && _options$filters4 !== void 0 && _options$filters4.id) {
    const fn = options.filters.id.includes('*') ? 'wildcard' : 'term';
    filters.push({
      [fn]: {
        'service.name': options.filters.id
      }
    });
  }
  if ((_options$filters5 = options.filters) !== null && _options$filters5 !== void 0 && _options$filters5['cloud.provider']) {
    filters.push({
      term: {
        'cloud.provider': options.filters['cloud.provider']
      }
    });
  }
  if ((_options$filters6 = options.filters) !== null && _options$filters6 !== void 0 && _options$filters6['cloud.region']) {
    filters.push({
      term: {
        'cloud.region': options.filters['cloud.region']
      }
    });
  }
  const apmIndices = await options.getApmIndices(options.savedObjectsClient);
  const {
    assets
  } = await (0, _services.collectServices)({
    client: options.elasticsearchClient,
    from: options.from,
    to: options.to || 'now',
    sourceIndices: {
      apm: apmIndices
    },
    filters
  });
  return {
    services: assets
  };
}