"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public_assets_client = require("./lib/public_assets_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Plugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.config = context.config.get();
    this.logger = context.logger.get();
  }
  setup(core) {
    // Check for config value and bail out if not "alpha-enabled"
    if (!this.config.alphaEnabled) {
      this.logger.debug('Public is NOT enabled');
      return;
    }
    this.logger.debug('Public is enabled');
    const publicAssetsClient = new _public_assets_client.PublicAssetsClient(core.http);
    return {
      publicAssetsClient
    };
  }
  start(core) {
    // Check for config value and bail out if not "alpha-enabled"
    if (!this.config.alphaEnabled) {
      return;
    }
    const publicAssetsClient = new _public_assets_client.PublicAssetsClient(core.http);
    return {
      publicAssetsClient
    };
  }
  stop() {}
}
exports.Plugin = Plugin;