"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exposeToBrowserConfig = exports.configSchema = exports.INDEX_DEFAULTS = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_DEFAULTS = exports.INDEX_DEFAULTS = {
  logs: 'filebeat-*,logs-*'
};
const configSchema = exports.configSchema = _configSchema.schema.object({
  alphaEnabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  // Designate where various types of data live.
  // NOTE: this should be handled in a centralized way for observability, so
  // that when a user configures these differently from the known defaults,
  // that value is propagated everywhere. For now, we duplicate the value here.
  sourceIndices: _configSchema.schema.object({
    logs: _configSchema.schema.string({
      defaultValue: INDEX_DEFAULTS.logs
    })
  }, {
    defaultValue: INDEX_DEFAULTS
  })
});
/**
 * The following map is passed to the server plugin setup under the
 * exposeToBrowser: option, and controls which of the above config
 * keys are allow-listed to be available in the browser config.
 *
 * NOTE: anything exposed here will be visible in the UI dev tools,
 * and therefore MUST NOT be anything that is sensitive information!
 */
const exposeToBrowserConfig = exports.exposeToBrowserConfig = {
  alphaEnabled: true
};