"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceMetadataIcons = getServiceMetadataIcons;
exports.should = void 0;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../common/es_fields/apm");
var _transactions = require("../../lib/helpers/transactions");
var _serverless = require("../../../common/serverless");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const should = exports.should = [{
  exists: {
    field: _apm.CONTAINER_ID
  }
}, {
  exists: {
    field: _apm.KUBERNETES_POD_NAME
  }
}, {
  exists: {
    field: _apm.CLOUD_PROVIDER
  }
}, {
  exists: {
    field: _apm.HOST_OS_PLATFORM
  }
}, {
  exists: {
    field: _apm.AGENT_NAME
  }
}, {
  exists: {
    field: _apm.AGENT_VERSION
  }
}, {
  exists: {
    field: _apm.SERVICE_FRAMEWORK_NAME
  }
}, {
  exists: {
    field: _apm.LABEL_TELEMETRY_AUTO_VERSION
  }
}];
async function getServiceMetadataIcons({
  serviceName,
  apmEventClient,
  searchAggregatedTransactions,
  start,
  end
}) {
  var _cloud$service;
  const filter = [{
    term: {
      [_apm.SERVICE_NAME]: serviceName
    }
  }, ...(0, _server.rangeQuery)(start, end)];
  const params = {
    apm: {
      events: [(0, _transactions.getProcessorEventForTransactions)(searchAggregatedTransactions), _common.ProcessorEvent.error, _common.ProcessorEvent.metric]
    },
    body: {
      track_total_hits: 1,
      size: 1,
      _source: [_apm.KUBERNETES, _apm.CLOUD_PROVIDER, _apm.CONTAINER_ID, _apm.AGENT_NAME, _apm.CLOUD_SERVICE_NAME],
      query: {
        bool: {
          filter,
          should
        }
      }
    }
  };
  const response = await apmEventClient.search('get_service_metadata_icons', params);
  if (response.hits.total.value === 0) {
    return {
      agentName: undefined,
      containerType: undefined,
      cloudProvider: undefined,
      serverlessType: undefined
    };
  }
  const {
    kubernetes,
    cloud,
    container,
    agent
  } = response.hits.hits[0]._source;
  let containerType;
  if (!!kubernetes) {
    containerType = 'Kubernetes';
  } else if (!!container) {
    containerType = 'Docker';
  }
  const serverlessType = (0, _serverless.getServerlessTypeFromCloudData)(cloud === null || cloud === void 0 ? void 0 : cloud.provider, cloud === null || cloud === void 0 ? void 0 : (_cloud$service = cloud.service) === null || _cloud$service === void 0 ? void 0 : _cloud$service.name);
  return {
    agentName: agent === null || agent === void 0 ? void 0 : agent.name,
    containerType,
    serverlessType,
    cloudProvider: cloud === null || cloud === void 0 ? void 0 : cloud.provider
  };
}