"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceInstancesMainStatistics = getServiceInstancesMainStatistics;
var _lodash = require("lodash");
var _with_apm_span = require("../../../utils/with_apm_span");
var _get_service_instances_system_metric_statistics = require("./get_service_instances_system_metric_statistics");
var _get_service_instances_transaction_statistics = require("./get_service_instances_transaction_statistics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceInstancesMainStatistics({
  sortDirection,
  sortField,
  ...params
}) {
  return (0, _with_apm_span.withApmSpan)('get_service_instances_main_statistics', async () => {
    const paramsForSubQueries = {
      ...params,
      size: 1000
    };
    const transactionStats = await (0, _get_service_instances_transaction_statistics.getServiceInstancesTransactionStatistics)({
      ...paramsForSubQueries,
      includeTimeseries: false
    });
    const serviceNodeIds = transactionStats.map(item => item.serviceNodeName);
    const systemMetricStats = await (0, _get_service_instances_system_metric_statistics.getServiceInstancesSystemMetricStatistics)({
      ...paramsForSubQueries,
      includeTimeseries: false,
      serviceNodeIds
    });
    const systemMetricStatsMap = (0, _lodash.keyBy)(systemMetricStats, 'serviceNodeName');
    const stats = transactionStats.length ? transactionStats.map(item => ({
      ...item,
      ...(systemMetricStatsMap[item.serviceNodeName] || {})
    })) : systemMetricStats;
    return (0, _lodash.orderBy)(stats, sortField, sortDirection).slice(0, 100);
  });
}