"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "environmentRt", {
  enumerable: true,
  get: function () {
    return _environment_rt.environmentRt;
  }
});
exports.transactionDataSourceRt = exports.serviceTransactionDataSourceRt = exports.rangeRt = exports.probabilityRt = exports.kueryRt = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _document_type = require("../../common/document_type");
var _rollup = require("../../common/rollup");
var _environment_rt = require("../../common/environment_rt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rangeRt = exports.rangeRt = t.type({
  start: _ioTsUtils.isoToEpochRt,
  end: _ioTsUtils.isoToEpochRt
});
const probabilityRt = exports.probabilityRt = t.type({
  probability: _ioTsUtils.toNumberRt
});
const kueryRt = exports.kueryRt = t.type({
  kuery: t.string
});
const serviceTransactionDataSourceRt = exports.serviceTransactionDataSourceRt = t.type({
  documentType: t.union([t.literal(_document_type.ApmDocumentType.ServiceTransactionMetric), t.literal(_document_type.ApmDocumentType.TransactionMetric), t.literal(_document_type.ApmDocumentType.TransactionEvent)]),
  rollupInterval: t.union([t.literal(_rollup.RollupInterval.OneMinute), t.literal(_rollup.RollupInterval.TenMinutes), t.literal(_rollup.RollupInterval.SixtyMinutes), t.literal(_rollup.RollupInterval.None)])
});
const transactionDataSourceRt = exports.transactionDataSourceRt = t.type({
  documentType: t.union([t.literal(_document_type.ApmDocumentType.TransactionMetric), t.literal(_document_type.ApmDocumentType.TransactionEvent)]),
  rollupInterval: t.union([t.literal(_rollup.RollupInterval.OneMinute), t.literal(_rollup.RollupInterval.TenMinutes), t.literal(_rollup.RollupInterval.SixtyMinutes), t.literal(_rollup.RollupInterval.None)])
});