"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetApmServicesListFunction = registerGetApmServicesListFunction;
var _i18n = require("@kbn/i18n");
var _service_health_status = require("../../common/service_health_status");
var _get_apm_alerts_client = require("../lib/helpers/get_apm_alerts_client");
var _get_ml_client = require("../lib/helpers/get_ml_client");
var _get_random_sampler = require("../lib/helpers/get_random_sampler");
var _get_apm_service_list = require("../routes/assistant_functions/get_apm_service_list");
var _non_empty_string_ref = require("../utils/non_empty_string_ref");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerGetApmServicesListFunction({
  apmEventClient,
  resources,
  registerFunction
}) {
  registerFunction({
    name: 'get_apm_services_list',
    description: `Gets a list of services`,
    descriptionForUser: _i18n.i18n.translate('xpack.apm.observabilityAiAssistant.functions.registerGetApmServicesList.descriptionForUser', {
      defaultMessage: `Gets the list of monitored services, their health status, and alerts.`
    }),
    parameters: {
      type: 'object',
      properties: {
        'service.environment': {
          ..._non_empty_string_ref.NON_EMPTY_STRING,
          description: 'Optionally filter the services by the environments that they are running in'
        },
        start: {
          ..._non_empty_string_ref.NON_EMPTY_STRING,
          description: 'The start of the time range, in Elasticsearch date math, like `now`.'
        },
        end: {
          ..._non_empty_string_ref.NON_EMPTY_STRING,
          description: 'The end of the time range, in Elasticsearch date math, like `now-24h`.'
        },
        healthStatus: {
          type: 'array',
          description: 'Filter service list by health status',
          items: {
            type: 'string',
            enum: [_service_health_status.ServiceHealthStatus.unknown, _service_health_status.ServiceHealthStatus.healthy, _service_health_status.ServiceHealthStatus.warning, _service_health_status.ServiceHealthStatus.critical]
          }
        }
      },
      required: ['start', 'end']
    }
  }, async ({
    arguments: args
  }, signal) => {
    const {
      logger
    } = resources;
    const [apmAlertsClient, mlClient, randomSampler] = await Promise.all([(0, _get_apm_alerts_client.getApmAlertsClient)(resources), (0, _get_ml_client.getMlClient)(resources), (0, _get_random_sampler.getRandomSampler)({
      security: resources.plugins.security,
      probability: 1,
      request: resources.request
    })]);
    return {
      content: await (0, _get_apm_service_list.getApmServiceList)({
        apmEventClient,
        apmAlertsClient,
        randomSampler,
        mlClient,
        logger,
        arguments: args
      })
    };
  });
}