"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaEnvironmentContextProvider = void 0;
var _react = require("react");
var _kibana_environment_context = require("./kibana_environment_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKibanaEnvironmentContextProvider = ({
  kibanaVersion,
  isCloudEnv,
  isServerlessEnv
}) => {
  const value = (0, _react.useMemo)(() => ({
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  }), [kibanaVersion, isCloudEnv, isServerlessEnv]);
  const Provider = ({
    kibanaEnvironment = {},
    children
  }) => {
    const newProvider = /*#__PURE__*/(0, _react.createElement)(_kibana_environment_context.KibanaEnvironmentContext.Provider, {
      value: {
        ...kibanaEnvironment,
        ...value
      },
      children
    });
    return newProvider;
  };
  return Provider;
};
exports.useKibanaEnvironmentContextProvider = useKibanaEnvironmentContextProvider;