"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatencyColumnLabel = getLatencyColumnLabel;
var _i18n = require("@kbn/i18n");
var _latency_aggregation_types = require("../../../../common/latency_aggregation_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLatencyColumnLabel(latencyAggregationType) {
  switch (latencyAggregationType) {
    case _latency_aggregation_types.LatencyAggregationType.avg:
      return _i18n.i18n.translate('xpack.apm.serviceOverview.latencyColumnAvgLabel', {
        defaultMessage: 'Latency (avg.)'
      });
    case _latency_aggregation_types.LatencyAggregationType.p95:
      return _i18n.i18n.translate('xpack.apm.serviceOverview.latencyColumnP95Label', {
        defaultMessage: 'Latency (95th)'
      });
    case _latency_aggregation_types.LatencyAggregationType.p99:
      return _i18n.i18n.translate('xpack.apm.serviceOverview.latencyColumnP99Label', {
        defaultMessage: 'Latency (99th)'
      });
    default:
      return _i18n.i18n.translate('xpack.apm.serviceOverview.latencyColumnDefaultLabel', {
        defaultMessage: 'Latency'
      });
  }
}