"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableSearchBar = TableSearchBar;
exports.getItemsFilteredBySearchQuery = getItemsFilteredBySearchQuery;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TableSearchBar({
  placeholder,
  searchQuery,
  onChangeSearchQuery
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "tableSearchInput",
    placeholder: placeholder,
    fullWidth: true,
    value: searchQuery,
    onChange: e => {
      onChangeSearchQuery(e.target.value);
    }
  });
}
function getItemsFilteredBySearchQuery({
  items,
  fieldsToSearch,
  searchQuery
}) {
  return items.filter(item => {
    return fieldsToSearch.some(field => {
      const fieldValue = item[field];
      return fieldValue === null || fieldValue === void 0 ? void 0 : fieldValue.toLowerCase().includes(searchQuery.toLowerCase());
    });
  });
}