"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Stacktrace = Stacktrace;
exports.getGroupedStackframes = getGroupedStackframes;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _empty_message = require("../empty_message");
var _library_stacktrace = require("./library_stacktrace");
var _stackframe = require("./stackframe");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Stacktrace({
  stackframes = [],
  codeLanguage
}) {
  if ((0, _lodash.isEmpty)(stackframes)) {
    return /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, {
      heading: _i18n.i18n.translate('xpack.apm.stacktraceTab.noStacktraceAvailableLabel', {
        defaultMessage: 'No stack trace available.'
      }),
      hideSubheading: true
    });
  }
  const groups = getGroupedStackframes(stackframes);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    whiteSpace: "pre",
    isCopyable: true
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, groups.map((group, i) => {
    // library frame
    if (group.isLibraryFrame && groups.length > 1) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: i
      }, /*#__PURE__*/_react.default.createElement(_library_stacktrace.LibraryStacktrace, {
        id: i.toString(),
        stackframes: group.stackframes,
        codeLanguage: codeLanguage
      }));
    }

    // non-library frame
    return group.stackframes.map((stackframe, idx) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `${i}-${idx}`
    }, /*#__PURE__*/_react.default.createElement(_stackframe.Stackframe, {
      codeLanguage: codeLanguage,
      id: `${i}-${idx}`,
      initialIsOpen: i === 0 && groups.length > 1,
      stackframe: stackframe
    })));
  })));
}
function getGroupedStackframes(stackframes) {
  return stackframes.reduce((acc, stackframe) => {
    const prevGroup = (0, _lodash.last)(acc);
    const shouldAppend = prevGroup && prevGroup.isLibraryFrame === stackframe.library_frame && !prevGroup.excludeFromGrouping && !stackframe.exclude_from_grouping;

    // append to group
    if (prevGroup && shouldAppend) {
      prevGroup.stackframes.push(stackframe);
      return acc;
    }

    // create new group
    acc.push({
      isLibraryFrame: Boolean(stackframe.library_frame),
      excludeFromGrouping: Boolean(stackframe.exclude_from_grouping),
      stackframes: [stackframe]
    });
    return acc;
  }, []);
}