"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDetailsByNameLink = TransactionDetailsByNameLink;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _react2 = require("@emotion/react");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _get_redirect_to_transaction_detail_page_url = require("../trace_link/get_redirect_to_transaction_detail_page_url");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionDetailsByNameLink() {
  const {
    query: {
      rangeFrom = 'now-15m',
      rangeTo = 'now',
      transactionName,
      serviceName
    }
  } = (0, _use_apm_params.useApmParams)('/link-to/transaction');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data = {
      transaction: null
    },
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/transactions', {
      params: {
        query: {
          start,
          end,
          transactionName,
          serviceName
        }
      }
    });
  }, [start, end, transactionName, serviceName]);
  if (status === _use_fetcher.FETCH_STATUS.SUCCESS) {
    if (data.transaction) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: (0, _get_redirect_to_transaction_detail_page_url.getRedirectToTransactionDetailPageUrl)({
          transaction: data.transaction,
          rangeFrom,
          rangeTo
        })
      });
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
          height: 100%;
          display: flex;
        `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "apmTrace",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.transactionDetailsLink.h2.transactionNotFound', {
        defaultMessage: 'No transaction found'
      }))
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        height: 100%;
        display: flex;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "apmTrace",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.transactionDetailsLink.h2.fetchingTransactionLabel', {
      defaultMessage: 'Fetching transaction...'
    }))
  }));
}